/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import org.bukkit.command.Command;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.command.RestartCommand;
import org.bukkit.craftbukkit.command.TicksPerSecondCommand;
import org.bukkit.craftbukkit.util.WatchdogThread;

public class Spigot {
    public static void initialize(CraftServer server, SimpleCommandMap commandMap, YamlConfiguration configuration) {
        int timeout;
        if (configuration.getBoolean("settings.restart-command", true)) {
            commandMap.register("bukkit", (Command)new RestartCommand("restart"));
        }
        if (configuration.getBoolean("settings.tps-command", true)) {
            commandMap.register("bukkit", (Command)new TicksPerSecondCommand("tps"));
        }
        if ((timeout = configuration.getInt("settings.timeout-time", 300)) == 180) {
            timeout = 300;
            server.getLogger().info("Migrating to new timeout time of 300");
            configuration.set("settings.timeout-time", (Object)timeout);
            server.saveConfig();
        }
        WatchdogThread.startThread(timeout, configuration.getBoolean("settings.restart-on-crash", false));
        server.whitelistMessage = configuration.getString("settings.whitelist-message", server.whitelistMessage);
        server.stopMessage = configuration.getString("settings.stop-message", server.stopMessage);
        server.logCommands = configuration.getBoolean("settings.log-commands", true);
        server.ipFilter = configuration.getBoolean("settings.filter-unsafe-ips", false);
        server.commandComplete = configuration.getBoolean("settings.command-complete", true);
        server.spamGuardExclusions = configuration.getStringList("settings.spam-exclusions");
        server.orebfuscatorEnabled = configuration.getBoolean("orebfuscator.enable", false);
        server.orebfuscatorUpdateRadius = configuration.getInt("orebfuscator.update-radius", 2);
        server.orebfuscatorDisabledWorlds = configuration.getStringList("orebfuscator.disabled-worlds");
        if (server.chunkGCPeriod == 0) {
            server.getLogger().severe("[Spigot] You should not disable chunk-gc. Resetting period-in-ticks to 600 ticks.");
            server.chunkGCPeriod = 600;
        }
    }
}

