/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.avaje.ebean.config.DataSourceConfig;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.SQLitePlatform;
import com.avaje.ebeaninternal.server.lib.sql.TransactionIsolation;
import guava10.com.google.common.collect.ImmutableList;
import guava10.com.google.common.collect.MapMaker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.console.ConsoleReader;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.conversations.Conversable;
import org.bukkit.craftbukkit.CraftOfflinePlayer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.Spigot;
import org.bukkit.craftbukkit.command.CraftSimpleCommandMap;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.help.SimpleHelpMap;
import org.bukkit.craftbukkit.inventory.CraftFurnaceRecipe;
import org.bukkit.craftbukkit.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.inventory.CraftRecipe;
import org.bukkit.craftbukkit.inventory.CraftShapedRecipe;
import org.bukkit.craftbukkit.inventory.CraftShapelessRecipe;
import org.bukkit.craftbukkit.inventory.RecipeIterator;
import org.bukkit.craftbukkit.map.CraftMapView;
import org.bukkit.craftbukkit.metadata.EntityMetadataStore;
import org.bukkit.craftbukkit.metadata.PlayerMetadataStore;
import org.bukkit.craftbukkit.metadata.WorldMetadataStore;
import org.bukkit.craftbukkit.potion.CraftPotionBrewer;
import org.bukkit.craftbukkit.scheduler.CraftScheduler;
import org.bukkit.craftbukkit.updater.AutoUpdater;
import org.bukkit.craftbukkit.updater.BukkitDLUpdaterService;
import org.bukkit.craftbukkit.util.DatFileFilter;
import org.bukkit.craftbukkit.util.Metrics;
import org.bukkit.craftbukkit.util.Versioning;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChatTabCompleteEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.help.HelpMap;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.SimpleServicesManager;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionBrewer;
import org.bukkit.scheduler.BukkitWorker;
import org.bukkit.util.StringUtil;
import org.bukkit.util.permissions.DefaultPermissions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.MarkedYAMLException;

public final class CraftServer
implements Server {
    private final String serverName = "CraftBukkit";
    private final String serverVersion;
    private final String bukkitVersion = Versioning.getBukkitVersion();
    private final ServicesManager servicesManager = new SimpleServicesManager();
    private final CraftScheduler scheduler = new CraftScheduler();
    private final CraftSimpleCommandMap craftCommandMap = new CraftSimpleCommandMap(this);
    private final SimpleCommandMap commandMap = new SimpleCommandMap((Server)this);
    private final SimpleHelpMap helpMap = new SimpleHelpMap(this);
    private final StandardMessenger messenger = new StandardMessenger();
    private final PluginManager pluginManager = new SimplePluginManager((Server)this, this.commandMap);
    protected final MinecraftServer console;
    protected final hn playerList;
    private final Map<String, World> worlds = new LinkedHashMap<String, World>();
    public YamlConfiguration configuration;
    private final Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
    private final Map<String, OfflinePlayer> offlinePlayers = new MapMaker().softValues().makeMap();
    private final AutoUpdater updater;
    private final EntityMetadataStore entityMetadata = new EntityMetadataStore();
    private final PlayerMetadataStore playerMetadata = new PlayerMetadataStore();
    private final WorldMetadataStore worldMetadata = new WorldMetadataStore();
    private int monsterSpawn = -1;
    private int animalSpawn = -1;
    private int waterAnimalSpawn = -1;
    private int ambientSpawn = -1;
    public int chunkGCPeriod = -1;
    public int chunkGCLoadThresh = 0;
    private File container;
    private Warning.WarningState warningState = Warning.WarningState.DEFAULT;
    public String whitelistMessage = "You are not white-listed on this server!";
    public String stopMessage = "Server restarting. Brb";
    public boolean logCommands = true;
    public boolean ipFilter = false;
    public boolean commandComplete = true;
    public List<String> spamGuardExclusions;
    private boolean dumpMaterials = false;
    private final BooleanWrapper online = new BooleanWrapper();
    public boolean orebfuscatorEnabled = false;
    public int orebfuscatorUpdateRadius = 2;
    public List<String> orebfuscatorDisabledWorlds;

    public CraftServer(MinecraftServer console, gm playerList) {
        this.console = console;
        this.playerList = (hn)playerList;
        this.serverVersion = CraftServer.class.getPackage().getImplementationVersion();
        this.online.value = console.getPropertyManager().a("online-mode", true);
        Bukkit.setServer((Server)this);
        xc.l.getClass();
        Potion.setPotionBrewer((PotionBrewer)new CraftPotionBrewer());
        ll.q.getClass();
        if (!Main.useConsole) {
            this.getLogger().info("Console input is disabled due to --noconsole command argument");
        }
        this.configuration = YamlConfiguration.loadConfiguration((File)this.getConfigFile());
        this.configuration.options().copyDefaults(true);
        this.configuration.setDefaults((Configuration)YamlConfiguration.loadConfiguration((InputStream)this.getClass().getClassLoader().getResourceAsStream("configurations/bukkit.yml")));
        this.saveConfig();
        ((SimplePluginManager)this.pluginManager).useTimings(this.configuration.getBoolean("settings.plugin-profiling"));
        this.monsterSpawn = this.configuration.getInt("spawn-limits.monsters");
        this.animalSpawn = this.configuration.getInt("spawn-limits.animals");
        this.waterAnimalSpawn = this.configuration.getInt("spawn-limits.water-animals");
        this.ambientSpawn = this.configuration.getInt("spawn-limits.ambient");
        console.autosavePeriod = this.configuration.getInt("ticks-per.autosave");
        this.warningState = Warning.WarningState.value((String)this.configuration.getString("settings.deprecated-verbose"));
        this.chunkGCPeriod = this.configuration.getInt("chunk-gc.period-in-ticks");
        this.chunkGCLoadThresh = this.configuration.getInt("chunk-gc.load-threshold");
        this.dumpMaterials = this.configuration.getBoolean("mcpc.dump-materials");
        this.updater = new AutoUpdater(new BukkitDLUpdaterService(this.configuration.getString("auto-updater.host")), this.getLogger(), this.configuration.getString("auto-updater.preferred-channel"));
        this.updater.setEnabled(false);
        this.updater.setSuggestChannels(this.configuration.getBoolean("auto-updater.suggest-channels"));
        this.updater.getOnBroken().addAll(this.configuration.getStringList("auto-updater.on-broken"));
        this.updater.getOnUpdate().addAll(this.configuration.getStringList("auto-updater.on-update"));
        this.updater.check(this.serverVersion);
        Spigot.initialize(this, this.commandMap, this.configuration);
        try {
            this.configuration.save(this.getConfigFile());
        }
        catch (IOException e2) {
            // empty catch block
        }
        try {
            new Metrics().start();
        }
        catch (IOException e3) {
            this.getLogger().log(Level.SEVERE, "Could not start metrics", e3);
        }
        this.loadPlugins();
        this.enablePlugins(PluginLoadOrder.STARTUP);
    }

    private File getConfigFile() {
        return (File)this.console.options.valueOf("bukkit-settings");
    }

    public void saveConfig() {
        try {
            this.configuration.save(this.getConfigFile());
        }
        catch (IOException ex2) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, "Could not save " + this.getConfigFile(), ex2);
        }
    }

    public void loadPlugins() {
        this.pluginManager.registerInterface(JavaPluginLoader.class);
        File pluginFolder = (File)this.console.options.valueOf("plugins");
        if (pluginFolder.exists()) {
            Plugin[] plugins;
            for (Plugin plugin : plugins = this.pluginManager.loadPlugins(pluginFolder)) {
                try {
                    String message = String.format("Loading %s", plugin.getDescription().getFullName());
                    plugin.getLogger().info(message);
                    plugin.onLoad();
                }
                catch (Throwable ex2) {
                    Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, ex2.getMessage() + " initializing " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex2);
                }
            }
        } else {
            pluginFolder.mkdir();
        }
    }

    public void enablePlugins(PluginLoadOrder type) {
        Plugin[] plugins;
        if (type == PluginLoadOrder.STARTUP) {
            this.helpMap.clear();
            this.helpMap.initializeGeneralTopics();
        }
        for (Plugin plugin : plugins = this.pluginManager.getPlugins()) {
            if (plugin.isEnabled() || plugin.getDescription().getLoad() != type) continue;
            this.loadPlugin(plugin);
        }
        if (type == PluginLoadOrder.POSTWORLD) {
            this.commandMap.registerServerAliases();
            this.loadCustomPermissions();
            DefaultPermissions.registerCorePermissions();
            this.helpMap.initializeCommands();
        }
    }

    public void disablePlugins() {
        this.pluginManager.disablePlugins();
    }

    private void loadPlugin(Plugin plugin) {
        try {
            this.pluginManager.enablePlugin(plugin);
            List perms = plugin.getDescription().getPermissions();
            for (Permission perm : perms) {
                try {
                    this.pluginManager.addPermission(perm);
                }
                catch (IllegalArgumentException ex2) {
                    this.getLogger().log(Level.WARNING, "Plugin " + plugin.getDescription().getFullName() + " tried to register permission '" + perm.getName() + "' but it's already registered", ex2);
                }
            }
        }
        catch (Throwable ex3) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, ex3.getMessage() + " loading " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex3);
        }
    }

    public String getName() {
        return "CraftBukkit";
    }

    public String getVersion() {
        return this.serverVersion + " (MC: " + this.console.x() + ")";
    }

    public String getBukkitVersion() {
        return this.bukkitVersion;
    }

    public Player[] getOnlinePlayers() {
        List online = this.playerList.b;
        Player[] players = new Player[online.size()];
        for (int i2 = 0; i2 < players.length; ++i2) {
            players[i2] = ((iq)online.get((int)i2)).a.getPlayerB();
        }
        return players;
    }

    public Player getPlayer(String name) {
        Player[] players = this.getOnlinePlayers();
        Player found = null;
        String lowerName = name.toLowerCase();
        int delta = Integer.MAX_VALUE;
        for (Player player : players) {
            if (!player.getName().toLowerCase().startsWith(lowerName)) continue;
            int curDelta = player.getName().length() - lowerName.length();
            if (curDelta < delta) {
                found = player;
                delta = curDelta;
            }
            if (curDelta == 0) break;
        }
        return found;
    }

    public Player getPlayerExact(String name) {
        String lname = name.toLowerCase();
        for (Player player : this.getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(lname)) continue;
            return player;
        }
        return null;
    }

    public int broadcastMessage(String message) {
        return this.broadcast(message, "bukkit.broadcast.user");
    }

    public Player getPlayer(iq entity) {
        return entity.a.getPlayerB();
    }

    public List<Player> matchPlayer(String partialName) {
        ArrayList<Player> matchedPlayers = new ArrayList<Player>();
        for (Player iterPlayer : this.getOnlinePlayers()) {
            String iterPlayerName = iterPlayer.getName();
            if (partialName.equalsIgnoreCase(iterPlayerName)) {
                matchedPlayers.clear();
                matchedPlayers.add(iterPlayer);
                break;
            }
            if (!iterPlayerName.toLowerCase().contains(partialName.toLowerCase())) continue;
            matchedPlayers.add(iterPlayer);
        }
        return matchedPlayers;
    }

    public int getMaxPlayers() {
        return this.playerList.l();
    }

    public int getPort() {
        return this.getConfigInt("server-port", 25565);
    }

    public int getViewDistance() {
        return this.getConfigInt("view-distance", 10);
    }

    public String getIp() {
        return this.getConfigString("server-ip", "");
    }

    public String getServerName() {
        return this.getConfigString("server-name", "Unknown Server");
    }

    public String getServerId() {
        return this.getConfigString("server-id", "unnamed");
    }

    public String getWorldType() {
        return this.getConfigString("level-type", "DEFAULT");
    }

    public boolean getGenerateStructures() {
        return this.getConfigBoolean("generate-structures", true);
    }

    public boolean getAllowEnd() {
        return this.configuration.getBoolean("settings.allow-end");
    }

    public boolean getAllowNether() {
        return this.getConfigBoolean("allow-nether", true);
    }

    public boolean getWarnOnOverload() {
        return this.configuration.getBoolean("settings.warn-on-overload");
    }

    public boolean getQueryPlugins() {
        return this.configuration.getBoolean("settings.query-plugins");
    }

    public boolean hasWhitelist() {
        return this.getConfigBoolean("white-list", false);
    }

    private String getConfigString(String variable, String defaultValue) {
        return this.console.getPropertyManager().a(variable, defaultValue);
    }

    private int getConfigInt(String variable, int defaultValue) {
        return this.console.getPropertyManager().a(variable, defaultValue);
    }

    private boolean getConfigBoolean(String variable, boolean defaultValue) {
        return this.console.getPropertyManager().a(variable, defaultValue);
    }

    public String getUpdateFolder() {
        return this.configuration.getString("settings.update-folder", "update");
    }

    public File getUpdateFolderFile() {
        return new File((File)this.console.options.valueOf("plugins"), this.configuration.getString("settings.update-folder", "update"));
    }

    public int getPingPacketLimit() {
        return this.configuration.getInt("settings.ping-packet-limit", 100);
    }

    public long getConnectionThrottle() {
        return this.configuration.getInt("settings.connection-throttle");
    }

    public int getTicksPerAnimalSpawns() {
        return this.configuration.getInt("ticks-per.animal-spawns");
    }

    public int getTicksPerMonsterSpawns() {
        return this.configuration.getInt("ticks-per.monster-spawns");
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public CraftScheduler getScheduler() {
        return this.scheduler;
    }

    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    public List<World> getWorlds() {
        return new ArrayList<World>(this.worlds.values());
    }

    public hn getHandle() {
        return this.playerList;
    }

    public boolean dispatchServerCommand(CommandSender sender, fo serverCommand) {
        Conversable conversable;
        if (sender instanceof Conversable && (conversable = (Conversable)sender).isConversing()) {
            conversable.acceptConversationInput(serverCommand.a);
            return true;
        }
        try {
            int space = serverCommand.a.indexOf(" ");
            if (this.getCommandMap().getCommand(serverCommand.a.substring(0, space != -1 ? space : serverCommand.a.length())) != null) {
                return this.dispatchCommand(sender, serverCommand.a);
            }
            this.craftCommandMap.setVanillaConsoleSender(serverCommand.b);
            return this.dispatchVanillaCommand(sender, serverCommand.a);
        }
        catch (Exception ex2) {
            this.getLogger().log(Level.WARNING, "Unexpected exception while parsing console command \"" + serverCommand.a + '\"', ex2);
            return false;
        }
    }

    public boolean dispatchCommand(CommandSender sender, String commandLine) {
        if (this.commandMap.dispatch(sender, commandLine)) {
            return true;
        }
        sender.sendMessage("Unknown command. Type \"help\" for help.");
        return false;
    }

    public boolean dispatchVanillaCommand(CommandSender sender, String commandLine) {
        if (this.craftCommandMap.dispatch(sender, commandLine)) {
            return true;
        }
        sender.sendMessage("Unknown command. Type \"help\" for help.");
        return false;
    }

    public boolean getConnectionLoggingEnabled() {
        return this.configuration.getBoolean("mcpc.connection-logging", false);
    }

    public boolean getInfiniteWaterSource() {
        return this.configuration.getBoolean("mcpc.infinite-water-source", true);
    }

    public boolean getDumpMaterials() {
        return this.configuration.getBoolean("mcpc.dump-materials", false);
    }

    public void reload() {
        go config;
        this.configuration = YamlConfiguration.loadConfiguration((File)this.getConfigFile());
        ((ho)this.console).o = config = new go(this.console.options);
        ((SimplePluginManager)this.pluginManager).useTimings(this.configuration.getBoolean("settings.plugin-profiling"));
        boolean animals = config.a("spawn-animals", this.console.V());
        boolean monsters = config.a("spawn-monsters", this.console.worlds.get((int)0).s > 0);
        int difficulty = config.a("difficulty", this.console.worlds.get((int)0).s);
        this.online.value = config.a("online-mode", this.console.U());
        this.console.e(config.a("spawn-animals", this.console.V()));
        this.console.g(config.a("pvp", this.console.X()));
        this.console.h(config.a("allow-flight", this.console.Y()));
        this.console.o(config.a("motd", this.console.aa()));
        this.monsterSpawn = this.configuration.getInt("spawn-limits.monsters");
        this.animalSpawn = this.configuration.getInt("spawn-limits.animals");
        this.waterAnimalSpawn = this.configuration.getInt("spawn-limits.water-animals");
        this.ambientSpawn = this.configuration.getInt("spawn-limits.ambient");
        this.warningState = Warning.WarningState.value((String)this.configuration.getString("settings.deprecated-verbose"));
        this.console.autosavePeriod = this.configuration.getInt("ticks-per.autosave");
        this.chunkGCPeriod = this.configuration.getInt("chunk-gc.period-in-ticks");
        this.chunkGCLoadThresh = this.configuration.getInt("chunk-gc.load-threshold");
        this.playerList.f().e();
        this.playerList.e().e();
        for (in world : this.console.worlds) {
            world.s = difficulty;
            world.a(monsters, animals);
            world.ticksPerAnimalSpawns = this.getTicksPerAnimalSpawns() < 0 ? 400L : (long)this.getTicksPerAnimalSpawns();
            if (this.getTicksPerMonsterSpawns() < 0) {
                world.ticksPerMonsterSpawns = 1L;
                continue;
            }
            world.ticksPerMonsterSpawns = this.getTicksPerMonsterSpawns();
        }
        this.pluginManager.clearPlugins();
        this.commandMap.clearCommands();
        this.resetRecipes();
        for (int pollCount = 0; pollCount < 50 && this.getScheduler().getActiveWorkers().size() > 0; ++pollCount) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
        }
        List<BukkitWorker> overdueWorkers = this.getScheduler().getActiveWorkers();
        for (BukkitWorker worker : overdueWorkers) {
            Plugin plugin = worker.getOwner();
            String author = "<NoAuthorGiven>";
            if (plugin.getDescription().getAuthors().size() > 0) {
                author = (String)plugin.getDescription().getAuthors().get(0);
            }
            this.getLogger().log(Level.SEVERE, String.format("Nag author: '%s' of '%s' about the following: %s", author, plugin.getDescription().getName(), "This plugin is not properly shutting down its async tasks when it is being reloaded.  This may cause conflicts with the newly loaded version of the plugin"));
        }
        Spigot.initialize(this, this.commandMap, this.configuration);
        this.loadPlugins();
        this.enablePlugins(PluginLoadOrder.STARTUP);
        this.enablePlugins(PluginLoadOrder.POSTWORLD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCustomPermissions() {
        Map perms;
        FileInputStream stream;
        File file = new File(this.configuration.getString("settings.permissions-file"));
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException ex2) {
            try {
                file.createNewFile();
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        try {
            perms = (Map)this.yaml.load((InputStream)stream);
        }
        catch (MarkedYAMLException ex3) {
            this.getLogger().log(Level.WARNING, "Server permissions file " + file + " is not valid YAML: " + ex3.toString());
            return;
        }
        catch (Throwable ex4) {
            this.getLogger().log(Level.WARNING, "Server permissions file " + file + " is not valid YAML.", ex4);
            try {
                stream.close();
            }
            catch (IOException ex5) {
                // empty catch block
            }
            return;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ex6) {}
        }
        if (perms == null) {
            this.getLogger().log(Level.INFO, "Server permissions file " + file + " is empty, ignoring it");
            return;
        }
        List permsList = Permission.loadPermissions((Map)perms, (String)("Permission node '%s' in " + file + " is invalid"), (PermissionDefault)Permission.DEFAULT_PERMISSION);
        for (Permission perm : permsList) {
            try {
                this.pluginManager.addPermission(perm);
            }
            catch (IllegalArgumentException ex7) {
                this.getLogger().log(Level.SEVERE, "Permission in " + file + " was already defined", ex7);
            }
        }
    }

    public String toString() {
        return "CraftServer{serverName=CraftBukkit,serverVersion=" + this.serverVersion + ",minecraftVersion=" + this.console.x() + '}';
    }

    public World createWorld(String name, World.Environment environment) {
        return WorldCreator.name((String)name).environment(environment).createWorld();
    }

    public World createWorld(String name, World.Environment environment, long seed) {
        return WorldCreator.name((String)name).environment(environment).seed(seed).createWorld();
    }

    public World createWorld(String name, World.Environment environment, ChunkGenerator generator) {
        return WorldCreator.name((String)name).environment(environment).generator(generator).createWorld();
    }

    public World createWorld(String name, World.Environment environment, long seed, ChunkGenerator generator) {
        return WorldCreator.name((String)name).environment(environment).seed(seed).generator(generator).createWorld();
    }

    public World createWorld(WorldCreator creator) {
        ahs converter;
        if (creator == null) {
            throw new IllegalArgumentException("Creator may not be null");
        }
        String name = creator.name();
        ChunkGenerator generator = creator.generator();
        File folder = new File(this.getWorldContainer(), name);
        World world = this.getWorld(name);
        yn type = yn.a(creator.type().getName());
        boolean generateStructures = creator.generateStructures();
        if (world != null) {
            return world;
        }
        if (folder.exists() && !folder.isDirectory()) {
            throw new IllegalArgumentException("File exists with the name '" + name + "' and isn't a folder");
        }
        if (generator == null) {
            generator = this.getGenerator(name);
        }
        if ((converter = new ahs(this.getWorldContainer())).b(name)) {
            this.getLogger().info("Converting world '" + name + "'");
            converter.a(name, new fw(this.console));
        }
        int dimension = 10 + this.console.worlds.size();
        boolean used = false;
        block0: do {
            for (in server : this.console.worlds) {
                used = server.dimension == dimension;
                if (!used) continue;
                ++dimension;
                continue block0;
            }
        } while (used);
        boolean hardcore = false;
        in internal = new in(this.console, new ahr(this.getWorldContainer(), name, true), name, dimension, new yk(creator.seed(), yl.a(this.getDefaultGameMode().getValue()), generateStructures, hardcore, type), this.console.b, creator.environment(), generator);
        DimensionManager.addMVDimension(dimension);
        DimensionManager.registerDimension(dimension, internal.u.h);
        if (!this.worlds.containsKey(name.toLowerCase())) {
            return null;
        }
        internal.A = this.console.worlds.get((int)0).A;
        internal.J = new ii(internal);
        internal.a(new ij(this.console, internal));
        internal.s = 1;
        internal.a(true, true);
        this.console.worlds.add(internal);
        if (generator != null) {
            internal.getWorld().getPopulators().addAll(generator.getDefaultPopulators((World)internal.getWorld()));
        }
        this.pluginManager.callEvent((Event)new WorldInitEvent((World)internal.getWorld()));
        System.out.print("Preparing start region for level " + (this.console.worlds.size() - 1) + " (Dimension: " + internal.dimension + ", Seed: " + internal.E() + ")");
        if (internal.getWorld().getKeepSpawnInMemory()) {
            int short1 = 196;
            long i2 = System.currentTimeMillis();
            for (int j2 = -short1; j2 <= short1; j2 += 16) {
                for (int k2 = -short1; k2 <= short1; k2 += 16) {
                    long l2 = System.currentTimeMillis();
                    if (l2 < i2) {
                        i2 = l2;
                    }
                    if (l2 > i2 + 1000L) {
                        int i1 = (short1 * 2 + 1) * (short1 * 2 + 1);
                        int j1 = (j2 + short1) * (short1 * 2 + 1) + k2 + 1;
                        System.out.println("Preparing spawn area for " + name + ", " + j1 * 100 / i1 + "%");
                        i2 = l2;
                    }
                    s chunkcoordinates = internal.H();
                    internal.b.c(chunkcoordinates.a + j2 >> 4, chunkcoordinates.c + k2 >> 4);
                }
            }
        }
        this.pluginManager.callEvent((Event)new WorldLoadEvent((World)internal.getWorld()));
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load(internal));
        return internal.getWorld();
    }

    public boolean unloadWorld(String name, boolean save) {
        return this.unloadWorld(this.getWorld(name), save);
    }

    public boolean unloadWorld(World world, boolean save) {
        if (world == null) {
            return false;
        }
        in handle = ((CraftWorld)world).getHandle();
        if (!this.console.worlds.contains(handle)) {
            return false;
        }
        if (handle.dimension <= 1) {
            return false;
        }
        if (handle.h.size() > 0) {
            return false;
        }
        WorldUnloadEvent e2 = new WorldUnloadEvent((World)handle.getWorld());
        this.pluginManager.callEvent((Event)e2);
        if (e2.isCancelled()) {
            return false;
        }
        if (save) {
            try {
                handle.a(true, (kj)null);
                handle.m();
                WorldSaveEvent event = new WorldSaveEvent((World)handle.getWorld());
                this.getPluginManager().callEvent((Event)event);
            }
            catch (yh ex2) {
                this.getLogger().log(Level.SEVERE, null, ex2);
            }
        }
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload(handle));
        DimensionManager.setWorld(handle.dimension, null);
        DimensionManager.unregisterDimension(handle.dimension);
        return true;
    }

    public MinecraftServer getServer() {
        return this.console;
    }

    public World getWorld(String name) {
        return this.worlds.get(name.toLowerCase());
    }

    public World getWorld(UUID uid) {
        for (World world : this.worlds.values()) {
            if (!world.getUID().equals(uid)) continue;
            return world;
        }
        return null;
    }

    public void addWorld(World world) {
        this.worlds.put(world.getName().toLowerCase(), world);
    }

    public Logger getLogger() {
        return MinecraftServer.a;
    }

    public ConsoleReader getReader() {
        return this.console.reader;
    }

    public PluginCommand getPluginCommand(String name) {
        Command command = this.commandMap.getCommand(name);
        if (command instanceof PluginCommand) {
            return (PluginCommand)command;
        }
        return null;
    }

    public void savePlayers() {
        this.playerList.g();
    }

    public void configureDbConfig(ServerConfig config) {
        DataSourceConfig ds2 = new DataSourceConfig();
        ds2.setDriver(this.configuration.getString("database.driver"));
        ds2.setUrl(this.configuration.getString("database.url"));
        ds2.setUsername(this.configuration.getString("database.username"));
        ds2.setPassword(this.configuration.getString("database.password"));
        ds2.setIsolationLevel(TransactionIsolation.getLevel((String)this.configuration.getString("database.isolation")));
        if (ds2.getDriver().contains("sqlite")) {
            config.setDatabasePlatform((DatabasePlatform)new SQLitePlatform());
            config.getDatabasePlatform().getDbDdlSyntax().setIdentity("");
        }
        config.setDataSourceConfig(ds2);
    }

    public boolean addRecipe(Recipe recipe) {
        CraftRecipe toAdd;
        if (recipe instanceof CraftRecipe) {
            toAdd = (CraftRecipe)recipe;
        } else if (recipe instanceof ShapedRecipe) {
            toAdd = CraftShapedRecipe.fromBukkitRecipe((ShapedRecipe)recipe);
        } else if (recipe instanceof ShapelessRecipe) {
            toAdd = CraftShapelessRecipe.fromBukkitRecipe((ShapelessRecipe)recipe);
        } else if (recipe instanceof FurnaceRecipe) {
            toAdd = CraftFurnaceRecipe.fromBukkitRecipe((FurnaceRecipe)recipe);
        } else {
            return false;
        }
        toAdd.addToCraftingManager();
        return true;
    }

    public List<Recipe> getRecipesFor(ItemStack result) {
        ArrayList<Recipe> results = new ArrayList<Recipe>();
        Iterator<Recipe> iter = this.recipeIterator();
        while (iter.hasNext()) {
            Recipe recipe = iter.next();
            ItemStack stack = recipe.getResult();
            if (stack.getType() != result.getType() || result.getDurability() != -1 && result.getDurability() != stack.getDurability()) continue;
            results.add(recipe);
        }
        return results;
    }

    public Iterator<Recipe> recipeIterator() {
        return new RecipeIterator();
    }

    public void clearRecipes() {
        wn.a().b.clear();
        wj.a().b.clear();
    }

    public void resetRecipes() {
        wn.a().b = new wn().b;
        wj.a().b = new wj().b;
    }

    public Map<String, String[]> getCommandAliases() {
        ConfigurationSection section = this.configuration.getConfigurationSection("aliases");
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
        if (section != null) {
            for (String key : section.getKeys(false)) {
                List commands = null;
                commands = section.isList(key) ? section.getStringList(key) : ImmutableList.of((Object)section.getString(key));
                result.put(key, commands.toArray(new String[commands.size()]));
            }
        }
        return result;
    }

    public void removeBukkitSpawnRadius() {
        this.configuration.set("settings.spawn-radius", null);
        this.saveConfig();
    }

    public int getBukkitSpawnRadius() {
        return this.configuration.getInt("settings.spawn-radius", -1);
    }

    public String getShutdownMessage() {
        return this.configuration.getString("settings.shutdown-message");
    }

    public int getSpawnRadius() {
        return ((ho)this.console).o.a("spawn-protection", 16);
    }

    public void setSpawnRadius(int value) {
        this.configuration.set("settings.spawn-radius", (Object)value);
        this.saveConfig();
    }

    public boolean getOnlineMode() {
        return this.online.value;
    }

    public boolean getAllowFlight() {
        return this.console.Y();
    }

    public boolean isHardcore() {
        return this.console.i();
    }

    public boolean useExactLoginLocation() {
        return this.configuration.getBoolean("settings.use-exact-login-location");
    }

    public ChunkGenerator getGenerator(String world) {
        String name;
        ConfigurationSection section = this.configuration.getConfigurationSection("worlds");
        ChunkGenerator result = null;
        if (section != null && (section = section.getConfigurationSection(world)) != null && (name = section.getString("generator")) != null && !name.equals("")) {
            String[] split = name.split(":", 2);
            String id2 = split.length > 1 ? split[1] : null;
            Plugin plugin = this.pluginManager.getPlugin(split[0]);
            if (plugin == null) {
                this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + split[0] + "' does not exist");
            } else if (!plugin.isEnabled()) {
                this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + split[0] + "' is not enabled yet (is it load:STARTUP?)");
            } else {
                result = plugin.getDefaultWorldGenerator(world, id2);
            }
        }
        return result;
    }

    public CraftMapView getMap(short id2) {
        aiv collection = this.console.worlds.get((int)0).A;
        ahn worldmap = (ahn)collection.a(ahn.class, "map_" + id2);
        if (worldmap == null) {
            return null;
        }
        return worldmap.mapView;
    }

    public CraftMapView createMap(World world) {
        ur stack = new ur(up.bd, 1, -1);
        ahn worldmap = up.bd.a(stack, ((CraftWorld)world).getHandle());
        return worldmap.mapView;
    }

    public void shutdown() {
        this.console.n();
    }

    public int broadcast(String message, String permission) {
        int count = 0;
        Set permissibles = this.getPluginManager().getPermissionSubscriptions(permission);
        for (Permissible permissible : permissibles) {
            if (!(permissible instanceof CommandSender) || !permissible.hasPermission(permission)) continue;
            CommandSender user = (CommandSender)permissible;
            user.sendMessage(message);
            ++count;
        }
        return count;
    }

    public OfflinePlayer getOfflinePlayer(String name) {
        Object result = this.getPlayerExact(name);
        String lname = name.toLowerCase();
        if (result == null) {
            result = this.offlinePlayers.get(lname);
            if (result == null) {
                result = new CraftOfflinePlayer(this, name);
                this.offlinePlayers.put(lname, (OfflinePlayer)result);
            }
        } else {
            this.offlinePlayers.remove(lname);
        }
        return result;
    }

    public Set<String> getIPBans() {
        return this.playerList.f().c().keySet();
    }

    public void banIP(String address) {
        fm entry = new fm(address);
        this.playerList.f().a(entry);
        this.playerList.f().f();
    }

    public void unbanIP(String address) {
        this.playerList.f().b(address);
        this.playerList.f().f();
    }

    public Set<OfflinePlayer> getBannedPlayers() {
        HashSet<OfflinePlayer> result = new HashSet<OfflinePlayer>();
        for (Object name : this.playerList.e().c().keySet()) {
            result.add(this.getOfflinePlayer((String)name));
        }
        return result;
    }

    public void setWhitelist(boolean value) {
        this.playerList.l = value;
        this.console.getPropertyManager().a("white-list", (Object)value);
    }

    public Set<OfflinePlayer> getWhitelistedPlayers() {
        LinkedHashSet<OfflinePlayer> result = new LinkedHashSet<OfflinePlayer>();
        for (Object name : this.playerList.h()) {
            if (((String)name).length() == 0 || ((String)name).startsWith("#")) continue;
            result.add(this.getOfflinePlayer((String)name));
        }
        return result;
    }

    public Set<OfflinePlayer> getOperators() {
        HashSet<OfflinePlayer> result = new HashSet<OfflinePlayer>();
        for (Object name : this.playerList.i()) {
            result.add(this.getOfflinePlayer((String)name));
        }
        return result;
    }

    public void reloadWhitelist() {
        this.playerList.j();
    }

    public GameMode getDefaultGameMode() {
        return GameMode.getByValue((int)this.console.worlds.get(0).K().r().a());
    }

    public void setDefaultGameMode(GameMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null");
        }
        for (World world : this.getWorlds()) {
            ((CraftWorld)world).getHandle().y.a(yl.a(mode.getValue()));
        }
    }

    public ConsoleCommandSender getConsoleSender() {
        return this.console.console;
    }

    public EntityMetadataStore getEntityMetadata() {
        return this.entityMetadata;
    }

    public PlayerMetadataStore getPlayerMetadata() {
        return this.playerMetadata;
    }

    public WorldMetadataStore getWorldMetadata() {
        return this.worldMetadata;
    }

    public void detectListNameConflict(iq entityPlayer) {
        for (int i2 = 0; i2 < this.getHandle().b.size(); ++i2) {
            iq testEntityPlayer = (iq)this.getHandle().b.get(i2);
            if (testEntityPlayer == entityPlayer || !testEntityPlayer.listName.equals(entityPlayer.listName)) continue;
            String oldName = entityPlayer.listName;
            int spaceLeft = 16 - oldName.length();
            entityPlayer.listName = spaceLeft <= 1 ? oldName.subSequence(0, oldName.length() - 2 - spaceLeft) + String.valueOf(System.currentTimeMillis() % 99L) : oldName + String.valueOf(System.currentTimeMillis() % 99L);
            return;
        }
    }

    public File getWorldContainer() {
        if (this.getServer().o != null) {
            return this.getServer().o;
        }
        if (this.container == null) {
            this.container = new File(this.configuration.getString("settings.world-container", "."));
        }
        return this.container;
    }

    public OfflinePlayer[] getOfflinePlayers() {
        ahv storage = (ahv)this.console.worlds.get(0).J();
        String[] files = storage.getPlayerDir().list(new DatFileFilter());
        HashSet<Object> players = new HashSet<Object>();
        for (String file : files) {
            players.add(this.getOfflinePlayer(file.substring(0, file.length() - 4)));
        }
        players.addAll(Arrays.asList(this.getOnlinePlayers()));
        return players.toArray(new OfflinePlayer[players.size()]);
    }

    public Messenger getMessenger() {
        return this.messenger;
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        for (Player player : this.getOnlinePlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getOnlinePlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onPlayerJoin(Player player) {
        if (!this.updater.isEnabled()) return;
        if (this.updater.getCurrent() == null) return;
        if (!player.hasPermission("bukkit.broadcast.admin")) return;
        if (this.updater.getCurrent().isBroken()) {
            if (this.updater.getOnBroken().contains("warn-ops")) {
                player.sendMessage(ChatColor.DARK_RED + "The version of CraftBukkit that this server is running is known to be broken. Please consider updating to the latest version at dl.bukkit.org.");
                return;
            }
        }
        if (!this.updater.isUpdateAvailable()) return;
        if (!this.updater.getOnUpdate().contains("warn-ops")) return;
        player.sendMessage(ChatColor.DARK_PURPLE + "The version of CraftBukkit that this server is running is out of date. Please consider updating to the latest version at dl.bukkit.org.");
    }

    public Inventory createInventory(InventoryHolder owner, InventoryType type) {
        return new CraftInventoryCustom(owner, type);
    }

    public Inventory createInventory(InventoryHolder owner, int size) throws IllegalArgumentException {
        Validate.isTrue((size % 9 == 0 ? 1 : 0) != 0, (String)"Chests must have a size that is a multiple of 9!");
        return new CraftInventoryCustom(owner, size);
    }

    public Inventory createInventory(InventoryHolder owner, int size, String title) throws IllegalArgumentException {
        Validate.isTrue((size % 9 == 0 ? 1 : 0) != 0, (String)"Chests must have a size that is a multiple of 9!");
        return new CraftInventoryCustom(owner, size, title);
    }

    public HelpMap getHelpMap() {
        return this.helpMap;
    }

    public SimpleCommandMap getCommandMap() {
        return this.commandMap;
    }

    public CraftSimpleCommandMap getCraftCommandMap() {
        return this.craftCommandMap;
    }

    public int getMonsterSpawnLimit() {
        return this.monsterSpawn;
    }

    public int getAnimalSpawnLimit() {
        return this.animalSpawn;
    }

    public int getWaterAnimalSpawnLimit() {
        return this.waterAnimalSpawn;
    }

    public int getAmbientSpawnLimit() {
        return this.ambientSpawn;
    }

    public boolean isPrimaryThread() {
        return Thread.currentThread().equals(this.console.primaryThread);
    }

    public String getMotd() {
        return this.console.aa();
    }

    public Warning.WarningState getWarningState() {
        return this.warningState;
    }

    public List<String> tabComplete(aa sender, String message) {
        if (!(sender instanceof iq)) {
            return ImmutableList.of();
        }
        CraftPlayer player = ((iq)sender).getBukkitEntity();
        if (message.startsWith("/")) {
            return this.tabCompleteCommand(player, message);
        }
        return this.tabCompleteChat(player, message);
    }

    public List<String> tabCompleteCommand(Player player, String message) {
        List completions = null;
        try {
            completions = this.commandComplete ? this.getCommandMap().tabComplete((CommandSender)player, message.substring(1)) : null;
        }
        catch (CommandException ex2) {
            player.sendMessage(ChatColor.RED + "An internal error occurred while attempting to tab-complete this command");
            this.getLogger().log(Level.SEVERE, "Exception when " + player.getName() + " attempted to tab complete " + message, ex2);
        }
        return completions == null ? ImmutableList.of() : completions;
    }

    public List<String> tabCompleteChat(Player player, String message) {
        Player[] players = this.getOnlinePlayers();
        ArrayList<String> completions = new ArrayList<String>();
        PlayerChatTabCompleteEvent event = new PlayerChatTabCompleteEvent(player, message, completions);
        String token = event.getLastToken();
        for (Player p2 : players) {
            if (!player.canSee(p2) || !StringUtil.startsWithIgnoreCase((String)p2.getName(), (String)token)) continue;
            completions.add(p2.getName());
        }
        this.pluginManager.callEvent((Event)event);
        Iterator it2 = completions.iterator();
        while (it2.hasNext()) {
            Object current = it2.next();
            if (current instanceof String) continue;
            it2.remove();
        }
        Collections.sort(completions, String.CASE_INSENSITIVE_ORDER);
        return completions;
    }

    public CraftItemFactory getItemFactory() {
        return CraftItemFactory.instance();
    }

    public void restart() {
        block12: {
            try {
                String startupScript = this.configuration.getString("settings.restart-script-location", "");
                File file = new File(startupScript);
                if (file.isFile()) {
                    System.out.println("Attempting to restart with " + startupScript);
                    for (Player p2 : this.getOnlinePlayers()) {
                        ((CraftPlayer)p2).kickPlayer("Server is restarting", true);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex2) {
                        // empty catch block
                    }
                    this.getServer().ae().a();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex3) {
                        // empty catch block
                    }
                    try {
                        this.getServer().k();
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    String os2 = System.getProperty("os.name").toLowerCase();
                    if (os2.contains("win")) {
                        Runtime.getRuntime().exec("cmd /c start " + file.getPath());
                    } else {
                        Runtime.getRuntime().exec(file.getPath());
                    }
                    System.exit(0);
                    break block12;
                }
                System.out.println("Startup script '" + startupScript + "' does not exist!");
            }
            catch (Exception ex4) {
                ex4.printStackTrace();
            }
        }
    }

    static {
        ConfigurationSerialization.registerClass(CraftOfflinePlayer.class);
        CraftItemFactory.instance();
    }

    private final class BooleanWrapper {
        private boolean value = true;

        private BooleanWrapper() {
        }
    }
}

