/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.CraftChunkSnapshot;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.entity.Entity;

public class CraftChunk
implements Chunk {
    private WeakReference<zz> weakChunk;
    private final in worldServer;
    private final int x;
    private final int z;
    private static final byte[] emptyData = new byte[2048];
    private static final short[] emptyBlockIDs = new short[4096];
    private static final byte[] emptySkyLight = new byte[2048];

    public CraftChunk(zz chunk) {
        if (!(chunk instanceof zy)) {
            this.weakChunk = new WeakReference<zz>(chunk);
        }
        this.worldServer = (in)this.getHandle().e;
        this.x = this.getHandle().g;
        this.z = this.getHandle().h;
    }

    public World getWorld() {
        return this.worldServer.getWorld();
    }

    public CraftWorld getCraftWorld() {
        return (CraftWorld)this.getWorld();
    }

    public zz getHandle() {
        zz c2 = (zz)this.weakChunk.get();
        if (c2 == null && !((c2 = this.worldServer.e(this.x, this.z)) instanceof zy)) {
            this.weakChunk = new WeakReference<zz>(c2);
        }
        return c2;
    }

    void breakLink() {
        this.weakChunk.clear();
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public String toString() {
        return "CraftChunk{x=" + this.getX() + "z=" + this.getZ() + '}';
    }

    public Block getBlock(int x2, int y2, int z2) {
        return new CraftBlock(this, this.getX() << 4 | x2 & 0xF, y2 & 0xFF, this.getZ() << 4 | z2 & 0xF);
    }

    public Entity[] getEntities() {
        int count = 0;
        int index = 0;
        zz chunk = this.getHandle();
        for (int i2 = 0; i2 < 16; ++i2) {
            count += chunk.j[i2].size();
        }
        Entity[] entities = new Entity[count];
        for (int i3 = 0; i3 < 16; ++i3) {
            for (Object obj : chunk.j[i3].toArray()) {
                if (!(obj instanceof lq)) continue;
                entities[index++] = ((lq)obj).getBukkitEntity();
            }
        }
        return entities;
    }

    public BlockState[] getTileEntities() {
        int index = 0;
        zz chunk = this.getHandle();
        BlockState[] entities = new BlockState[chunk.i.size()];
        for (Object obj : chunk.i.keySet().toArray()) {
            if (!(obj instanceof yv)) continue;
            yv position = (yv)obj;
            entities[index++] = this.worldServer.getWorld().getBlockAt(position.a + (chunk.g << 4), position.b, position.c + (chunk.h << 4)).getState();
        }
        return entities;
    }

    public boolean isLoaded() {
        return this.getWorld().isChunkLoaded((Chunk)this);
    }

    public boolean load() {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), true);
    }

    public boolean load(boolean generate) {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), generate);
    }

    public boolean unload() {
        return this.getWorld().unloadChunk(this.getX(), this.getZ());
    }

    public boolean unload(boolean save) {
        return this.getWorld().unloadChunk(this.getX(), this.getZ(), save);
    }

    public boolean unload(boolean save, boolean safe) {
        return this.getWorld().unloadChunk(this.getX(), this.getZ(), save, safe);
    }

    public ChunkSnapshot getChunkSnapshot() {
        return this.getChunkSnapshot(true, false, false);
    }

    public ChunkSnapshot getChunkSnapshot(boolean includeMaxBlockY, boolean includeBiome, boolean includeBiomeTempRain) {
        zz chunk = this.getHandle();
        aaa[] cs2 = chunk.i();
        short[][] sectionBlockIDs = new short[cs2.length][];
        byte[][] sectionBlockData = new byte[cs2.length][];
        byte[][] sectionSkyLights = new byte[cs2.length][];
        byte[][] sectionEmitLights = new byte[cs2.length][];
        boolean[] sectionEmpty = new boolean[cs2.length];
        for (int i2 = 0; i2 < cs2.length; ++i2) {
            if (cs2[i2] == null) {
                sectionBlockIDs[i2] = emptyBlockIDs;
                sectionBlockData[i2] = emptyData;
                sectionSkyLights[i2] = emptySkyLight;
                sectionEmitLights[i2] = emptyData;
                sectionEmpty[i2] = true;
                continue;
            }
            short[] blockids = new short[4096];
            byte[] baseids = cs2[i2].g();
            for (int j2 = 0; j2 < 4096; ++j2) {
                blockids[j2] = (short)(baseids[j2] & 0xFF);
            }
            if (cs2[i2].i() != null) {
                int j3;
                if (cs2[i2].i().isTrivialArray()) {
                    int tval = cs2[i2].i().getTrivialArrayValue();
                    if (tval != 0) {
                        tval <<= 8;
                        j3 = 0;
                        while (j3 < 4096) {
                            int n2 = j3++;
                            blockids[n2] = (short)(blockids[n2] | tval);
                        }
                    }
                } else {
                    byte[] extids = cs2[i2].i().getValueArray();
                    for (j3 = 0; j3 < 2048; ++j3) {
                        short b2 = (short)(extids[j3] & 0xFF);
                        if (b2 == 0) continue;
                        int n3 = j3 << 1;
                        blockids[n3] = (short)(blockids[n3] | (b2 & 0xF) << 8);
                        int n4 = (j3 << 1) + 1;
                        blockids[n4] = (short)(blockids[n4] | (b2 & 0xF0) << 4);
                    }
                }
            }
            sectionBlockIDs[i2] = blockids;
            if (cs2[i2].j().isTrivialArray() && cs2[i2].j().getTrivialArrayValue() == 0) {
                sectionBlockData[i2] = emptyData;
            } else {
                sectionBlockData[i2] = new byte[2048];
                cs2[i2].j().copyToByteArray(sectionBlockData[i2], 0);
            }
            if (cs2[i2].l() == null) {
                sectionSkyLights[i2] = emptyData;
            } else if (cs2[i2].l().isTrivialArray()) {
                if (cs2[i2].l().getTrivialArrayValue() == 0) {
                    sectionSkyLights[i2] = emptyData;
                } else if (cs2[i2].l().getTrivialArrayValue() == 15) {
                    sectionSkyLights[i2] = emptySkyLight;
                } else {
                    sectionSkyLights[i2] = new byte[2048];
                    cs2[i2].l().copyToByteArray(sectionSkyLights[i2], 0);
                }
            } else {
                sectionSkyLights[i2] = new byte[2048];
                cs2[i2].l().copyToByteArray(sectionSkyLights[i2], 0);
            }
            if (cs2[i2].k().isTrivialArray() && cs2[i2].k().getTrivialArrayValue() == 0) {
                sectionEmitLights[i2] = emptyData;
                continue;
            }
            sectionEmitLights[i2] = new byte[2048];
            cs2[i2].k().copyToByteArray(sectionEmitLights[i2], 0);
        }
        int[] hmap = null;
        if (includeMaxBlockY) {
            hmap = new int[256];
            System.arraycopy(chunk.f, 0, hmap, 0, 256);
        }
        yy[] biome = null;
        double[] biomeTemp = null;
        double[] biomeRain = null;
        if (includeBiome || includeBiomeTempRain) {
            zd wcm = chunk.e.t();
            if (includeBiome) {
                biome = new yy[256];
                for (int i3 = 0; i3 < 256; ++i3) {
                    biome[i3] = chunk.a(i3 & 0xF, i3 >> 4, wcm);
                }
            }
            if (includeBiomeTempRain) {
                int i4;
                biomeTemp = new double[256];
                biomeRain = new double[256];
                float[] dat = wcm.b((float[])null, this.getX() << 4, this.getZ() << 4, 16, 16);
                for (i4 = 0; i4 < 256; ++i4) {
                    biomeTemp[i4] = dat[i4];
                }
                dat = wcm.a((float[])null, this.getX() << 4, this.getZ() << 4, 16, 16);
                for (i4 = 0; i4 < 256; ++i4) {
                    biomeRain[i4] = dat[i4];
                }
            }
        }
        World world = this.getWorld();
        return new CraftChunkSnapshot(this.getX(), this.getZ(), world.getName(), world.getFullTime(), sectionBlockIDs, sectionBlockData, sectionSkyLights, sectionEmitLights, sectionEmpty, hmap, biome, biomeTemp, biomeRain);
    }

    public static ChunkSnapshot getEmptyChunkSnapshot(int x2, int z2, CraftWorld world, boolean includeBiome, boolean includeBiomeTempRain) {
        yy[] biome = null;
        double[] biomeTemp = null;
        double[] biomeRain = null;
        if (includeBiome || includeBiomeTempRain) {
            zd wcm = world.getHandle().t();
            if (includeBiome) {
                biome = new yy[256];
                for (int i2 = 0; i2 < 256; ++i2) {
                    biome[i2] = world.getHandle().a((x2 << 4) + (i2 & 0xF), (z2 << 4) + (i2 >> 4));
                }
            }
            if (includeBiomeTempRain) {
                int i3;
                biomeTemp = new double[256];
                biomeRain = new double[256];
                float[] dat = wcm.b((float[])null, x2 << 4, z2 << 4, 16, 16);
                for (i3 = 0; i3 < 256; ++i3) {
                    biomeTemp[i3] = dat[i3];
                }
                dat = wcm.a((float[])null, x2 << 4, z2 << 4, 16, 16);
                for (i3 = 0; i3 < 256; ++i3) {
                    biomeRain[i3] = dat[i3];
                }
            }
        }
        int hSection = world.getMaxHeight() >> 4;
        short[][] blockIDs = new short[hSection][];
        byte[][] skyLight = new byte[hSection][];
        byte[][] emitLight = new byte[hSection][];
        byte[][] blockData = new byte[hSection][];
        boolean[] empty = new boolean[hSection];
        for (int i4 = 0; i4 < hSection; ++i4) {
            blockIDs[i4] = emptyBlockIDs;
            skyLight[i4] = emptySkyLight;
            emitLight[i4] = emptyData;
            blockData[i4] = emptyData;
            empty[i4] = true;
        }
        return new CraftChunkSnapshot(x2, z2, world.getName(), world.getFullTime(), blockIDs, blockData, skyLight, emitLight, empty, new int[256], biome, biomeTemp, biomeRain);
    }

    static {
        Arrays.fill(emptySkyLight, (byte)-1);
    }
}

