/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.network.NetworkModHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.CraftServer;

public class ModListResponsePacket
extends FMLPacket {
    private Map<String, String> modVersions;
    private List<String> missingMods;

    public ModListResponsePacket() {
        super(FMLPacket.Type.MOD_LIST_RESPONSE);
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        Map modVersions = (Map)data[0];
        List missingMods = (List)data[1];
        ByteArrayDataOutput dat = ByteStreams.newDataOutput();
        dat.writeInt(modVersions.size());
        for (Map.Entry version : modVersions.entrySet()) {
            dat.writeUTF((String)version.getKey());
            dat.writeUTF((String)version.getValue());
        }
        dat.writeInt(missingMods.size());
        for (String missing : missingMods) {
            dat.writeUTF(missing);
        }
        return dat.toByteArray();
    }

    @Override
    public FMLPacket consumePacket(byte[] data) {
        ByteArrayDataInput dat = ByteStreams.newDataInput((byte[])data);
        int versionListSize = dat.readInt();
        this.modVersions = Maps.newHashMapWithExpectedSize((int)versionListSize);
        for (int i2 = 0; i2 < versionListSize; ++i2) {
            String modName = dat.readUTF();
            String modVersion = dat.readUTF();
            this.modVersions.put(modName, modVersion);
        }
        int missingModSize = dat.readInt();
        this.missingMods = Lists.newArrayListWithExpectedSize((int)missingModSize);
        for (int i3 = 0; i3 < missingModSize; ++i3) {
            this.missingMods.add(dat.readUTF());
        }
        return this;
    }

    @Override
    public void execute(ce network, FMLNetworkHandler handler, eg netHandler, String userName) {
        NetworkModHandler networkMod;
        HashMap indexedModList = Maps.newHashMap(Loader.instance().getIndexedModList());
        ArrayList missingClientMods = Lists.newArrayList();
        ArrayList versionIncorrectMods = Lists.newArrayList();
        for (String string : this.missingMods) {
            ModContainer mc2 = (ModContainer)indexedModList.get(string);
            networkMod = handler.findNetworkModHandler(mc2);
            if (!networkMod.requiresClientSide()) continue;
            missingClientMods.add(string);
        }
        for (Map.Entry entry : this.modVersions.entrySet()) {
            ModContainer mc2 = (ModContainer)indexedModList.get(entry.getKey());
            networkMod = handler.findNetworkModHandler(mc2);
            if (networkMod.acceptVersion((String)entry.getValue())) continue;
            versionIncorrectMods.add(entry.getKey());
        }
        di pkt = new di();
        pkt.a = "FML";
        if (missingClientMods.size() > 0 || versionIncorrectMods.size() > 0) {
            pkt.c = FMLPacket.makePacket(FMLPacket.Type.MOD_MISSING, missingClientMods, versionIncorrectMods);
            if (((CraftServer)Bukkit.getServer()).getConnectionLoggingEnabled()) {
                Logger.getLogger("Minecraft").info(String.format("User %s connection failed: missing %s, bad versions %s", userName, missingClientMods, versionIncorrectMods));
                FMLLog.info("User %s connection failed: missing %s, bad versions %s", userName, missingClientMods, versionIncorrectMods);
            }
            FMLNetworkHandler.setHandlerState((it)netHandler, -2);
            pkt.b = pkt.c.length;
            network.a(pkt);
        } else {
            pkt.c = FMLPacket.makePacket(FMLPacket.Type.MOD_IDENTIFIERS, netHandler);
            if (((CraftServer)Bukkit.getServer()).getConnectionLoggingEnabled()) {
                Logger.getLogger("Minecraft").info(String.format("User %s connecting with mods %s", userName, this.modVersions.keySet()));
                FMLLog.info("User %s connecting with mods %s", userName, this.modVersions.keySet());
            }
            pkt.b = pkt.c.length;
            network.a(pkt);
            by by2 = new by();
            GameData.writeItemData(by2);
            byte[][] registryPackets = FMLPacket.makePacketSet(FMLPacket.Type.MOD_IDMAP, by2);
            for (int i2 = 0; i2 < registryPackets.length; ++i2) {
                network.a(PacketDispatcher.getPacket("FML", registryPackets[i2]));
            }
        }
        it.a((it)netHandler, true);
    }
}

