/*
 * Decompiled with CFR 0.152.
 */
package kr.entree.spigradle.annotations;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kr.entree.spigradle.annotations.BungeePlugin;
import kr.entree.spigradle.annotations.NukkitPlugin;
import kr.entree.spigradle.annotations.Plugin;
import kr.entree.spigradle.annotations.PluginMain;
import kr.entree.spigradle.annotations.SpigotPlugin;

public enum PluginType {
    SPIGOT("spigotAnnotationResultPath", "build/spigradle/spigot_main", SpigotPlugin.class),
    BUNGEE("bungeeAnnotationResultPath", "build/spigradle/bungee_main", BungeePlugin.class),
    NUKKIT("nukkitAnnotationResultPath", "build/spigradle/nukkit_main", NukkitPlugin.class),
    GENERAL("pluginAnnotationResultPath", "build/spigradle/plugin_main", PluginMain.class, Plugin.class);

    private final String pathKey;
    private final String defaultPath;
    private final List<Class<? extends Annotation>> annotations;

    @SafeVarargs
    private PluginType(String pathKey, String defaultPath, Class<? extends Annotation> ... annotations) {
        this.pathKey = pathKey;
        this.defaultPath = defaultPath;
        this.annotations = Arrays.asList(annotations);
    }

    public String getPathKey() {
        return this.pathKey;
    }

    public String getDefaultPath() {
        return this.defaultPath;
    }

    public List<Class<? extends Annotation>> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }
}

