/*
 * Decompiled with CFR 0.152.
 */
package kr.entree.spigradle.annotations;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import kr.entree.spigradle.annotations.PluginType;

@SupportedAnnotationTypes(value={"kr.entree.spigradle.annotations.SpigotPlugin", "kr.entree.spigradle.annotations.BungeePlugin", "kr.entree.spigradle.annotations.NukkitPlugin", "kr.entree.spigradle.annotations.PluginMain", "kr.entree.spigradle.annotations.Plugin"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"spigotAnnotationResultPath", "bungeeAnnotationResultPath", "nukkitAnnotationResultPath", "pluginAnnotationResultPath"})
@AutoService(value={Processor.class})
public class PluginAnnotationProcessor
extends AbstractProcessor {
    public static final String SPIGOT_PATH_KEY = "spigotAnnotationResultPath";
    public static final String BUNGEE_PATH_KEY = "bungeeAnnotationResultPath";
    public static final String NUKKIT_PATH_KEY = "nukkitAnnotationResultPath";
    public static final String GENERAL_PATH_KEY = "pluginAnnotationResultPath";
    private final Map<PluginType, String> resultByType = new HashMap<PluginType, String>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            for (Map.Entry<PluginType, String> entry : this.resultByType.entrySet()) {
                PluginType type2 = entry.getKey();
                String result = entry.getValue();
                if (result.isEmpty()) continue;
                File file = new File(this.processingEnv.getOptions().getOrDefault(type2.getPathKey(), type2.getDefaultPath()));
                PluginAnnotationProcessor.write(file, result).ifPresent(PluginAnnotationProcessor::error);
            }
        } else {
            Arrays.stream(PluginType.values()).map(type -> type.getAnnotations().stream().map(annotation -> PluginAnnotationProcessor.findClassName(roundEnv, annotation).orElse(null)).filter(Objects::nonNull).findFirst().map(name -> this.putResult((PluginType)((Object)type), (String)name)).orElse(PluginAnnotationProcessor.doNothing())).forEach(Runnable::run);
        }
        return true;
    }

    private Runnable putResult(PluginType type, String result) {
        return () -> this.resultByType.put(type, result);
    }

    private static Optional<String> findClassName(RoundEnvironment roundEnv, Class<? extends Annotation> annotation) {
        return roundEnv.getElementsAnnotatedWith(annotation).stream().filter(it -> it instanceof QualifiedNameable && it.getAnnotation(annotation) != null).findFirst().map(it -> ((QualifiedNameable)it).getQualifiedName().toString());
    }

    private static void error(Throwable throwable) {
        throw new IllegalStateException("Error while processing the annotations", throwable);
    }

    private static Runnable doNothing() {
        return () -> {};
    }

    private static Optional<Exception> write(File file, String contents) {
        File parent = file.getParentFile();
        if (!parent.mkdirs() && !parent.isDirectory()) {
            return Optional.of(new IllegalStateException("Couldn't create the parent directories"));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), StandardCharsets.UTF_8);){
            writer.write(contents);
        }
        catch (Exception ex) {
            return Optional.of(ex);
        }
        return Optional.empty();
    }
}

