/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.integration;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Map;
import javax.cache.integration.CacheLoader;
import org.jsr107.tck.support.OperationHandler;
import org.jsr107.tck.support.Server;

public class CacheLoaderServer<K, V>
extends Server {
    private volatile CacheLoader<K, V> cacheLoader;

    public CacheLoaderServer(int port) {
        this(port, null);
    }

    public CacheLoaderServer(int port, CacheLoader<K, V> cacheLoader) {
        super(port);
        this.addOperationHandler(new LoadOperationHandler());
        this.addOperationHandler(new LoadAllOperationHandler());
        this.cacheLoader = cacheLoader;
    }

    public void setCacheLoader(CacheLoader<K, V> cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public class LoadOperationHandler
    implements OperationHandler {
        @Override
        public String getType() {
            return "load";
        }

        @Override
        public void onProcess(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException {
            if (CacheLoaderServer.this.cacheLoader == null) {
                throw new NullPointerException("The CacheLoader for the CacheLoaderServer has not be set");
            }
            Object key = ois.readObject();
            Object value = null;
            try {
                value = CacheLoaderServer.this.cacheLoader.load(key);
                oos.writeObject(value);
            }
            catch (Exception e) {
                oos.writeObject(e);
            }
        }
    }

    public class LoadAllOperationHandler
    implements OperationHandler {
        @Override
        public String getType() {
            return "loadAll";
        }

        @Override
        public void onProcess(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException {
            if (CacheLoaderServer.this.cacheLoader == null) {
                throw new NullPointerException("The CacheLoader for the CacheLoaderServer has not be set");
            }
            HashSet<Object> keys = new HashSet<Object>();
            Object key = ois.readObject();
            while (key != null) {
                keys.add(key);
                key = ois.readObject();
            }
            Map map = null;
            try {
                map = CacheLoaderServer.this.cacheLoader.loadAll(keys);
            }
            catch (Exception e) {
                oos.writeObject(e);
            }
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    oos.writeObject(entry.getKey());
                    oos.writeObject(entry.getValue());
                }
                oos.writeObject(null);
            }
        }
    }
}

