/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.support;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsr107.tck.support.OperationHandler;

public class Server
implements AutoCloseable {
    public static final Logger LOG = Logger.getLogger(Server.class.getName());
    private int port;
    private ConcurrentHashMap<String, OperationHandler> operationHandlers;
    private ServerSocket serverSocket;
    private Thread serverThread;
    private ConcurrentHashMap<Integer, ClientConnection> clientConnections;
    private AtomicBoolean isTerminating;
    private static InetAddress serverSocketAddress = null;

    public Server(int port) {
        this.port = port;
        this.operationHandlers = new ConcurrentHashMap();
        this.serverSocket = null;
        this.serverThread = null;
        this.clientConnections = new ConcurrentHashMap();
        this.isTerminating = new AtomicBoolean(false);
    }

    public void addOperationHandler(OperationHandler handler) {
        this.operationHandlers.put(handler.getType(), handler);
    }

    public synchronized InetAddress open() throws IOException {
        if (this.serverSocket == null) {
            this.serverSocket = this.createServerSocket();
            this.serverThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        int connectionId = 0;
                        while (!Server.this.isTerminating.get()) {
                            Socket socket = Server.this.serverSocket.accept();
                            ClientConnection clientConnection = new ClientConnection(connectionId++, socket);
                            Server.this.clientConnections.put(clientConnection.getIdentity(), clientConnection);
                            clientConnection.start();
                        }
                    }
                    catch (NullPointerException e) {
                        Server.this.isTerminating.compareAndSet(false, true);
                    }
                    catch (IOException e) {
                        Server.this.isTerminating.compareAndSet(false, true);
                    }
                }
            });
            this.serverThread.start();
        }
        return this.getInetAddress();
    }

    public synchronized InetAddress getInetAddress() {
        if (this.serverSocket != null) {
            try {
                return this.getServerInetAddress();
            }
            catch (SocketException e) {
                return this.serverSocket.getInetAddress();
            }
            catch (UnknownHostException e) {
                return this.serverSocket.getInetAddress();
            }
        }
        throw new IllegalStateException("Server is not open");
    }

    public synchronized int getPort() {
        if (this.serverSocket != null) {
            return this.port;
        }
        throw new IllegalStateException("Server is not open");
    }

    @Override
    public synchronized void close() {
        if (this.serverSocket != null) {
            this.isTerminating.set(true);
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.serverSocket = null;
            this.serverThread.interrupt();
            this.serverThread = null;
            for (ClientConnection clientConnection : this.clientConnections.values()) {
                clientConnection.close();
            }
            this.clientConnections = new ConcurrentHashMap();
            this.isTerminating.set(false);
        }
    }

    private ServerSocket createServerSocket() throws IOException {
        boolean ephemeralPort = false;
        ServerSocket result = null;
        try {
            result = new ServerSocket(this.port);
        }
        catch (IOException e) {
            result = new ServerSocket(0);
            LOG.warning("createServerSocket: unable to use requested port " + this.port + "; using ephemeral port " + result.getLocalPort());
            this.port = result.getLocalPort();
        }
        LOG.log(Level.INFO, "Starting " + this.getClass().getCanonicalName() + " server at address:" + this.getServerInetAddress() + " port:" + this.port);
        return result;
    }

    private InetAddress getServerInetAddress() throws SocketException, UnknownHostException {
        if (serverSocketAddress == null) {
            boolean preferIPV4Stack = Boolean.getBoolean("java.net.preferIPv4Stack");
            boolean preferIPV6Addresses = Boolean.getBoolean("java.net.preferIPv6Addresses") && !preferIPV4Stack;
            try {
                serverSocketAddress = Server.getFirstNonLoopbackAddress(preferIPV4Stack, preferIPV6Addresses);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            if (serverSocketAddress == null) {
                LOG.warning("no remote ip address available so only possible to test using loopback address.");
                serverSocketAddress = InetAddress.getLocalHost();
            }
        }
        return serverSocketAddress;
    }

    private static InetAddress getFirstNonLoopbackAddress(boolean preferIPv4, boolean preferIPv6) throws SocketException {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            if (i.isVirtual() || i.isPointToPoint() || !i.isUp()) continue;
            LOG.info("Interface name is: " + i.getDisplayName());
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress()) continue;
                if (addr instanceof Inet4Address) {
                    if (preferIPv6) continue;
                    return addr;
                }
                if (!(addr instanceof Inet6Address) || preferIPv4) continue;
                return addr;
            }
        }
        return null;
    }

    private class ClientConnection
    extends Thread
    implements AutoCloseable {
        private int identity;
        private Socket socket;

        public ClientConnection(int identity, Socket socket) {
            this.identity = identity;
            this.socket = socket;
        }

        public int getIdentity() {
            return this.identity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(this.socket.getOutputStream());
                    ObjectInputStream ois = new ObjectInputStream(this.socket.getInputStream());
                    while (true) {
                        try {
                            while (true) {
                                String operation = (String)ois.readObject();
                                OperationHandler handler = (OperationHandler)Server.this.operationHandlers.get(operation);
                                if (handler == null) continue;
                                handler.onProcess(ois, oos);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    if (this.socket != null) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    Server.this.clientConnections.remove(this.identity);
                }
            }
            catch (Throwable throwable) {
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                Server.this.clientConnections.remove(this.identity);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.socket = null;
            }
        }
    }
}

