/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.annotation;

import domain.Blog;
import manager.BlogManager;
import org.jsr107.tck.annotation.AbstractInterceptionTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractBlogManagerInterceptionTest
extends AbstractInterceptionTest {
    protected abstract BlogManager getBlogManager();

    @Before
    public void before() {
        this.getBlogManager().clearCache();
    }

    @Test
    public void test_AT_CacheResult() {
        String testBody = "" + System.currentTimeMillis();
        String testTitle = "title a";
        Blog blog = new Blog(testTitle, testBody);
        BlogManager blogManager = this.getBlogManager();
        blogManager.createEntry(blog);
        Blog entryCached = blogManager.getEntryCached(testTitle);
        Assert.assertEquals((Object)entryCached.getBody(), (Object)testBody);
        blogManager.clearEntry(testTitle);
        entryCached = blogManager.getEntryCached(testTitle);
        Assert.assertNotNull((String)"Item should still be in the cache thus not null", (Object)entryCached);
        Assert.assertEquals((String)"Item should still be in the cache and the title should be the same as before", (Object)entryCached.getBody(), (Object)testBody);
    }

    @Test
    public void test_AT_CacheResult_UsingAt_CacheKeyParam() {
        String testBody = "" + System.currentTimeMillis();
        String testTitle = "title abc";
        Blog blog = new Blog(testTitle, testBody);
        BlogManager blogManager = this.getBlogManager();
        blogManager.createEntry(blog);
        Blog entryCached = blogManager.getEntryCached("asdf", testTitle, "adsfa");
        Assert.assertEquals((Object)entryCached.getBody(), (Object)testBody);
        blogManager.clearEntry(testTitle);
        entryCached = blogManager.getEntryCached(testTitle);
        Assert.assertNotNull((String)"Item should still be in the cache thus not null", (Object)entryCached);
        Assert.assertEquals((String)"Item should still be in the cache and the title should be the same as before", (Object)entryCached.getBody(), (Object)testBody);
    }

    @Test
    public void test_AT_CacheRemoveEntry() {
        String testBody = "" + System.currentTimeMillis();
        String testTitle = "title b";
        Blog blog = new Blog(testTitle, testBody);
        BlogManager blogManager = this.getBlogManager();
        blogManager.createEntry(blog);
        Blog entryCached = blogManager.getEntryCached(testTitle);
        Assert.assertEquals((Object)entryCached.getBody(), (Object)testBody);
        blogManager.clearEntryFromCache(testTitle);
        blogManager.clearEntry(testTitle);
        entryCached = blogManager.getEntryCached(testTitle);
        Assert.assertNull((String)"Item should removed from the cache and the map", (Object)entryCached);
    }

    @Test
    public void test_AT_CacheRemoveAll() {
        String testBody = "" + System.currentTimeMillis();
        String testTitle = "title b";
        Blog blog = new Blog(testTitle, testBody);
        BlogManager blogManager = this.getBlogManager();
        blogManager.createEntry(blog);
        Blog entryCached = blogManager.getEntryCached(testTitle);
        Assert.assertEquals((Object)entryCached.getBody(), (Object)testBody);
        blogManager.clearEntry(testTitle);
        blogManager.clearCache();
        entryCached = blogManager.getEntryCached(testTitle);
        Assert.assertNull((String)"Item should removed from the cache and the map", (Object)entryCached);
    }
}

