/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck;

import java.net.URI;
import java.util.Properties;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CachingTest {
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(this.getClass());

    @Test
    public void getCachingProviderSingleton() {
        CachingProvider provider1 = Caching.getCachingProvider();
        CachingProvider provider2 = Caching.getCachingProvider();
        Assert.assertEquals((Object)provider1, (Object)provider2);
    }

    @Test
    public void getCacheManager_singleton() {
        CachingProvider provider = Caching.getCachingProvider();
        CacheManager manager = provider.getCacheManager();
        manager.getProperties();
        Assert.assertNotNull((Object)manager);
        Assert.assertSame((Object)manager, (Object)provider.getCacheManager());
    }

    @Test
    public void getCacheManager_defaultURI() {
        CachingProvider provider = Caching.getCachingProvider();
        Assert.assertSame((Object)provider.getCacheManager(), (Object)provider.getCacheManager(provider.getDefaultURI(), provider.getDefaultClassLoader()));
        CacheManager manager = provider.getCacheManager();
        Assert.assertEquals((Object)provider.getDefaultURI(), (Object)manager.getURI());
    }

    @Test
    public void getCacheManager_nonNullProperties() {
        CachingProvider provider = Caching.getCachingProvider();
        Properties properties = new Properties();
        Assert.assertSame((Object)provider.getCacheManager(), (Object)provider.getCacheManager(provider.getDefaultURI(), provider.getDefaultClassLoader(), new Properties()));
        CacheManager manager = provider.getCacheManager();
        Assert.assertEquals((Object)properties, (Object)manager.getProperties());
    }

    @Test
    public void getCacheManager_URI() throws Exception {
        CachingProvider provider = Caching.getCachingProvider();
        URI uri = provider.getDefaultURI();
        CacheManager manager = provider.getCacheManager(uri, provider.getDefaultClassLoader());
        Assert.assertNotNull((Object)manager);
        Assert.assertSame((Object)manager, (Object)provider.getCacheManager(uri, provider.getDefaultClassLoader()));
        Assert.assertEquals((Object)uri, (Object)manager.getURI());
    }

    @Test
    public void getCacheManager_nullUriParameter() {
        CachingProvider provider = Caching.getCachingProvider();
        URI NULL_URI = null;
        CacheManager manager = provider.getCacheManager(NULL_URI, provider.getDefaultClassLoader(), null);
        Assert.assertNotNull((Object)manager);
        Assert.assertEquals((Object)provider.getDefaultURI(), (Object)manager.getURI());
    }

    @Test
    public void getCacheManager_nullClassLoader() {
        CachingProvider provider = Caching.getCachingProvider();
        ClassLoader NULL_CLASSLOADER = null;
        CacheManager manager = provider.getCacheManager(provider.getDefaultURI(), NULL_CLASSLOADER, null);
        Assert.assertNotNull((Object)manager);
        CacheManager sameManager = provider.getCacheManager(provider.getDefaultURI(), provider.getDefaultClassLoader(), null);
        Assert.assertEquals((Object)sameManager, (Object)manager);
        Assert.assertEquals((Object)sameManager.getClassLoader(), (Object)manager.getClassLoader());
    }

    @Test
    public void isSupported() {
        OptionalFeature[] features;
        CachingProvider provider = Caching.getCachingProvider();
        for (OptionalFeature feature : features = OptionalFeature.values()) {
            boolean value = provider.isSupported(feature);
            Logger.getLogger(this.getClass().getName()).info("Optional feature " + feature + " supported=" + value);
        }
    }

    @Test
    public void cachingProviderGetCache() {
        String name = "c1";
        Caching.getCachingProvider().getCacheManager().createCache(name, (Configuration)new MutableConfiguration().setTypes(Long.class, String.class));
        Cache cache = Caching.getCache((String)name, Long.class, String.class);
        Assert.assertEquals((Object)name, (Object)cache.getName());
        Caching.getCachingProvider().getCacheManager().destroyCache(name);
    }

    @Test
    public void cachingProviderGetNonExistentCache() {
        String name = "nonExistentCache";
        Cache cache = Caching.getCache((String)name, Long.class, String.class);
        Assert.assertNull(null, (Object)cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=NullPointerException.class)
    public void getCacheNullValueClass() {
        String name = "c1";
        CacheManager manager = Caching.getCachingProvider().getCacheManager();
        manager.createCache(name, (Configuration)new MutableConfiguration().setTypes(Long.class, String.class));
        try {
            Caching.getCache((String)name, Long.class, null);
        }
        finally {
            manager.destroyCache(name);
        }
    }

    @Test
    public void dummyTest() {
        junit.framework.Assert.fail();
    }
}

