/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.spi;

import java.util.Properties;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import org.junit.Assert;
import org.junit.Test;

public class CachingProviderTest {
    private static final ClassLoader CLASS_LOADER = CachingProviderTest.class.getClassLoader();

    @Test
    public void getCacheManagerUsingNulls() {
        CachingProvider provider = Caching.getCachingProvider();
        Properties properties = new Properties();
        try {
            provider.getCacheManager(null, null, null);
        }
        catch (NullPointerException e) {
            Assert.fail();
        }
        try {
            provider.getCacheManager(null, null, properties);
        }
        catch (NullPointerException e) {
            Assert.fail();
        }
        try {
            provider.getCacheManager(null, provider.getDefaultClassLoader(), null);
        }
        catch (NullPointerException e) {
            Assert.fail();
        }
        try {
            provider.getCacheManager(null, provider.getDefaultClassLoader(), properties);
        }
        catch (NullPointerException e) {
            Assert.fail();
        }
        try {
            provider.getCacheManager(provider.getDefaultURI(), null, null);
        }
        catch (NullPointerException e) {
            Assert.fail();
        }
        try {
            provider.getCacheManager(provider.getDefaultURI(), null, properties);
        }
        catch (NullPointerException e) {
            Assert.fail();
        }
        try {
            provider.getCacheManager(provider.getDefaultURI(), provider.getDefaultClassLoader(), null);
        }
        catch (NullPointerException e) {
            Assert.fail();
        }
        try {
            provider.getCacheManager(provider.getDefaultURI(), provider.getDefaultClassLoader(), properties);
        }
        catch (NullPointerException e) {
            Assert.fail();
        }
        try {
            provider.getCacheManager(null, null);
        }
        catch (NullPointerException e) {
            Assert.fail();
        }
        try {
            provider.getCacheManager(provider.getDefaultURI(), null);
        }
        catch (NullPointerException e) {
            Assert.fail();
        }
    }

    @Test
    public void getCacheManagerUsingDefaultURI() {
        CachingProvider provider = Caching.getCachingProvider();
        CacheManager manager1 = provider.getCacheManager();
        Assert.assertNotNull((Object)manager1);
        Assert.assertEquals((Object)provider.getDefaultURI(), (Object)manager1.getURI());
        CacheManager manager2 = provider.getCacheManager();
        Assert.assertSame((Object)manager1, (Object)manager2);
    }

    @Test
    public void getCacheManagerUsingSameNameAndClassLoader() {
        CachingProvider provider = Caching.getCachingProvider();
        ClassLoader loader = CLASS_LOADER;
        CacheManager manager1 = provider.getCacheManager(provider.getDefaultURI(), loader, null);
        Assert.assertNotNull((Object)manager1);
        CacheManager manager2 = provider.getCacheManager(provider.getDefaultURI(), loader, null);
        Assert.assertSame((Object)manager1, (Object)manager2);
    }

    @Test
    public void getCacheManagerUsingSameURIDifferentClassLoader() {
        CachingProvider provider = Caching.getCachingProvider();
        ClassLoader loader1 = CLASS_LOADER;
        CacheManager manager1 = provider.getCacheManager(provider.getDefaultURI(), loader1, null);
        Assert.assertNotNull((Object)manager1);
        MyClassLoader loader2 = new MyClassLoader(CLASS_LOADER);
        CacheManager manager2 = provider.getCacheManager(provider.getDefaultURI(), (ClassLoader)loader2, null);
        Assert.assertNotNull((Object)manager2);
        Assert.assertNotSame((Object)manager1, (Object)manager2);
    }

    @Test
    public void closeCacheManagers() {
        CachingProvider provider = Caching.getCachingProvider();
        ClassLoader loader1 = CLASS_LOADER;
        CacheManager manager1 = provider.getCacheManager(provider.getDefaultURI(), loader1, null);
        manager1.close();
        MyClassLoader loader2 = new MyClassLoader(CLASS_LOADER);
        CacheManager manager2 = provider.getCacheManager(provider.getDefaultURI(), (ClassLoader)loader2, null);
        manager2.close();
        Assert.assertNotSame((Object)manager1, (Object)provider.getCacheManager(provider.getDefaultURI(), loader1, null));
        Assert.assertNotSame((Object)manager2, (Object)provider.getCacheManager(provider.getDefaultURI(), (ClassLoader)loader2, null));
    }

    @Test
    public void closeCachingProvider() {
        CachingProvider provider = Caching.getCachingProvider();
        ClassLoader loader1 = CLASS_LOADER;
        CacheManager manager1 = provider.getCacheManager(provider.getDefaultURI(), loader1, null);
        MyClassLoader loader2 = new MyClassLoader(CLASS_LOADER);
        CacheManager manager2 = provider.getCacheManager(provider.getDefaultURI(), (ClassLoader)loader2, null);
        provider.close();
        Assert.assertNotSame((Object)manager1, (Object)provider.getCacheManager(provider.getDefaultURI(), loader1, null));
        Assert.assertNotSame((Object)manager2, (Object)provider.getCacheManager(provider.getDefaultURI(), (ClassLoader)loader2, null));
    }

    @Test
    public void closeCacheManagerByURIAndClassLoader() {
        CachingProvider provider = Caching.getCachingProvider();
        ClassLoader loader1 = CLASS_LOADER;
        CacheManager manager1 = provider.getCacheManager(provider.getDefaultURI(), loader1, null);
        MyClassLoader loader2 = new MyClassLoader(CLASS_LOADER);
        CacheManager manager2 = provider.getCacheManager(provider.getDefaultURI(), (ClassLoader)loader2, null);
        provider.close(manager1.getURI(), loader1);
        provider.close(manager2.getURI(), (ClassLoader)loader2);
        Assert.assertNotSame((Object)manager1, (Object)provider.getCacheManager(provider.getDefaultURI(), loader1, null));
        Assert.assertNotSame((Object)manager2, (Object)provider.getCacheManager(provider.getDefaultURI(), (ClassLoader)loader2, null));
    }

    @Test
    public void closeCacheManagersByClassLoader() {
        CachingProvider provider = Caching.getCachingProvider();
        ClassLoader loader1 = CLASS_LOADER;
        CacheManager manager1 = provider.getCacheManager(provider.getDefaultURI(), loader1, null);
        MyClassLoader loader2 = new MyClassLoader(CLASS_LOADER);
        CacheManager manager2 = provider.getCacheManager(provider.getDefaultURI(), (ClassLoader)loader2, null);
        provider.close(loader1);
        provider.close((ClassLoader)loader2);
        Assert.assertNotSame((Object)manager1, (Object)provider.getCacheManager(provider.getDefaultURI(), loader1, null));
        Assert.assertNotSame((Object)manager2, (Object)provider.getCacheManager(provider.getDefaultURI(), (ClassLoader)loader2, null));
    }

    private static class MyClassLoader
    extends ClassLoader {
        public MyClassLoader(ClassLoader parent) {
            super(parent);
        }
    }
}

