/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.Promise;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;

public abstract class SqlConnectionFactoryBase
implements ConnectionFactory {
    protected final VertxInternal vertx;
    protected final NetClient netClient;
    protected final SocketAddress socketAddress;
    protected final String username;
    protected final String password;
    protected final String database;
    protected final Map<String, String> properties;
    protected final boolean cachePreparedStatements;
    protected final int preparedStatementCacheSize;
    protected final Predicate<String> preparedStatementCacheSqlFilter;
    protected final CloseFuture clientCloseFuture = new CloseFuture();
    private final int reconnectAttempts;
    private final long reconnectInterval;

    protected SqlConnectionFactoryBase(VertxInternal vertx, SqlConnectOptions options) {
        this.vertx = vertx;
        this.socketAddress = options.getSocketAddress();
        this.username = options.getUser();
        this.password = options.getPassword();
        this.database = options.getDatabase();
        this.properties = options.getProperties() == null ? null : Collections.unmodifiableMap(options.getProperties());
        this.cachePreparedStatements = options.getCachePreparedStatements();
        this.preparedStatementCacheSize = options.getPreparedStatementCacheMaxSize();
        this.preparedStatementCacheSqlFilter = options.getPreparedStatementCacheSqlFilter();
        this.reconnectAttempts = options.getReconnectAttempts();
        this.reconnectInterval = options.getReconnectInterval();
        this.initializeConfiguration(options);
        NetClientOptions netClientOptions = new NetClientOptions((NetClientOptions)options);
        this.configureNetClientOptions(netClientOptions);
        netClientOptions.setReconnectAttempts(0);
        this.netClient = vertx.createNetClient(netClientOptions, this.clientCloseFuture);
    }

    @Override
    public void connect(Promise<Connection> promise) {
        PromiseInternal promiseInternal = (PromiseInternal)promise;
        ContextInternal context = promiseInternal.context();
        context.emit(promise, p -> this.doConnectWithRetry((PromiseInternal<Connection>)promiseInternal, this.reconnectAttempts));
    }

    @Override
    public void close(Promise<Void> promise) {
        this.clientCloseFuture.close(promise);
    }

    private void doConnectWithRetry(PromiseInternal<Connection> promise, int remainingAttempts) {
        ContextInternal context = promise.context();
        PromiseInternal promise0 = context.promise();
        promise0.future().onComplete(ar -> {
            if (ar.succeeded()) {
                promise.complete(ar.result());
            } else if (remainingAttempts >= 0) {
                context.owner().setTimer(this.reconnectInterval, id -> this.doConnectWithRetry(promise, remainingAttempts - 1));
            } else {
                promise.fail(ar.cause());
            }
        });
        this.doConnectInternal((Promise<Connection>)promise0);
    }

    protected abstract void initializeConfiguration(SqlConnectOptions var1);

    protected abstract void configureNetClientOptions(NetClientOptions var1);

    protected abstract void doConnectInternal(Promise<Connection> var1);
}

