/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.sqlclient.Cursor;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.RowStream;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.ArrayTuple;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.CursorImpl;
import io.vertx.sqlclient.impl.QueryBase;
import io.vertx.sqlclient.impl.QueryExecutor;
import io.vertx.sqlclient.impl.RowSetImpl;
import io.vertx.sqlclient.impl.RowStreamImpl;
import io.vertx.sqlclient.impl.TupleInternal;
import io.vertx.sqlclient.impl.command.CloseCursorCommand;
import io.vertx.sqlclient.impl.command.CloseStatementCommand;
import io.vertx.sqlclient.impl.command.CommandScheduler;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collector;

class PreparedStatementImpl
implements PreparedStatement {
    private final Connection conn;
    private final QueryTracer tracer;
    private final ClientMetrics metrics;
    private final ContextInternal context;
    private final String sql;
    private Promise<io.vertx.sqlclient.impl.PreparedStatement> promise;
    private Future<io.vertx.sqlclient.impl.PreparedStatement> future;
    private final boolean autoCommit;
    private final AtomicBoolean closed = new AtomicBoolean();

    static PreparedStatement create(Connection conn, QueryTracer tracer, ClientMetrics metrics, ContextInternal context, io.vertx.sqlclient.impl.PreparedStatement ps, boolean autoCommit) {
        return new PreparedStatementImpl(conn, tracer, metrics, context, ps, autoCommit);
    }

    static PreparedStatement create(Connection conn, QueryTracer tracer, ClientMetrics metrics, ContextInternal context, String sql, boolean autoCommit) {
        return new PreparedStatementImpl(conn, tracer, metrics, context, sql, autoCommit);
    }

    private PreparedStatementImpl(Connection conn, QueryTracer tracer, ClientMetrics metrics, ContextInternal context, io.vertx.sqlclient.impl.PreparedStatement ps, boolean autoCommit) {
        this.conn = conn;
        this.tracer = tracer;
        this.metrics = metrics;
        this.context = context;
        this.sql = null;
        this.promise = null;
        this.future = Future.succeededFuture((Object)ps);
        this.autoCommit = autoCommit;
    }

    private PreparedStatementImpl(Connection conn, QueryTracer tracer, ClientMetrics metrics, ContextInternal context, String sql, boolean autoCommit) {
        this.conn = conn;
        this.tracer = tracer;
        this.metrics = metrics;
        this.context = context;
        this.sql = sql;
        this.promise = Promise.promise();
        this.autoCommit = autoCommit;
    }

    @Override
    public PreparedQuery<RowSet<Row>> query() {
        QueryExecutor builder = new QueryExecutor(this.tracer, this.metrics, RowSetImpl.FACTORY, RowSetImpl.COLLECTOR);
        return new PreparedStatementQuery(builder);
    }

    void withPreparedStatement(Tuple args, Handler<AsyncResult<io.vertx.sqlclient.impl.PreparedStatement>> handler) {
        if (this.context == Vertx.currentContext()) {
            if (this.future == null) {
                PrepareStatementCommand prepare = new PrepareStatementCommand(this.sql, true, args.types());
                this.conn.schedule(this.context, prepare).onComplete(this.promise);
                this.future = this.promise.future();
            }
            this.future.onComplete(handler);
        } else {
            this.context.runOnContext(v -> this.withPreparedStatement(args, handler));
        }
    }

    <R, F extends SqlResult<R>> void execute(Tuple args, int fetch, String cursorId, boolean suspended, QueryExecutor<R, ?, F> builder, PromiseInternal<F> p) {
        this.withPreparedStatement(args, (Handler<AsyncResult<io.vertx.sqlclient.impl.PreparedStatement>>)((Handler)ar -> {
            if (ar.succeeded()) {
                builder.executeExtendedQuery(this.conn, (io.vertx.sqlclient.impl.PreparedStatement)ar.result(), this.autoCommit, args, fetch, cursorId, suspended, p);
            } else {
                p.fail(ar.cause());
            }
        }));
    }

    <R, F extends SqlResult<R>> void executeBatch(List<Tuple> argsList, QueryExecutor<R, ?, F> builder, PromiseInternal<F> p) {
        this.withPreparedStatement(argsList.get(0), (Handler<AsyncResult<io.vertx.sqlclient.impl.PreparedStatement>>)((Handler)ar -> {
            if (ar.succeeded()) {
                builder.executeBatchQuery((CommandScheduler)this.conn, (io.vertx.sqlclient.impl.PreparedStatement)ar.result(), this.autoCommit, argsList, p);
            } else {
                p.fail(ar.cause());
            }
        }));
    }

    @Override
    public Cursor cursor(Tuple args) {
        return this.cursor((TupleInternal)args);
    }

    private Cursor cursor(TupleInternal args) {
        return new CursorImpl(this, this.conn, this.tracer, this.metrics, this.context, this.autoCommit, args);
    }

    @Override
    public Future<Void> close() {
        if (this.closed.compareAndSet(false, true)) {
            PromiseInternal promise = this.context.promise();
            if (this.promise == null) {
                CloseStatementCommand cmd = new CloseStatementCommand((io.vertx.sqlclient.impl.PreparedStatement)this.future.result());
                this.conn.schedule(this.context, cmd).onComplete((Handler)promise);
            } else {
                if (this.future == null) {
                    this.future = this.promise.future();
                    this.promise.fail("Closed");
                }
                this.future.onComplete(arg_0 -> this.lambda$close$3((Promise)promise, arg_0));
            }
            return promise.future();
        }
        return this.context.failedFuture("Already closed");
    }

    @Override
    public RowStream<Row> createStream(int fetch, Tuple args) {
        return new RowStreamImpl(this, this.context, fetch, args);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        Future<Void> fut = this.close();
        if (completionHandler != null) {
            fut.onComplete(completionHandler);
        }
    }

    void closeCursor(String cursorId, Promise<Void> promise) {
        this.future.onComplete(ar -> {
            if (ar.succeeded()) {
                CloseCursorCommand cmd = new CloseCursorCommand(cursorId, (io.vertx.sqlclient.impl.PreparedStatement)ar.result());
                this.conn.schedule(this.context, cmd).onComplete((Handler)promise);
            } else {
                promise.fail(ar.cause());
            }
        });
    }

    private /* synthetic */ void lambda$close$3(Promise promise, AsyncResult ar) {
        if (ar.succeeded()) {
            CloseStatementCommand cmd = new CloseStatementCommand((io.vertx.sqlclient.impl.PreparedStatement)ar.result());
            this.conn.schedule(this.context, cmd).onComplete((Handler)promise);
        } else {
            promise.complete();
        }
    }

    private class PreparedStatementQuery<T, R extends SqlResult<T>>
    extends QueryBase<T, R>
    implements PreparedQuery<R> {
        public PreparedStatementQuery(QueryExecutor<T, ?, R> builder) {
            super(builder);
        }

        @Override
        protected <T2, R2 extends SqlResult<T2>> QueryBase<T2, R2> copy(QueryExecutor<T2, ?, R2> builder) {
            return new PreparedStatementQuery<T2, R2>(builder);
        }

        @Override
        public <U> PreparedQuery<SqlResult<U>> collecting(Collector<Row, ?, U> collector) {
            return (PreparedQuery)super.collecting(collector);
        }

        @Override
        public <U> PreparedQuery<RowSet<U>> mapping(Function<Row, U> mapper) {
            return (PreparedQuery)super.mapping(mapper);
        }

        @Override
        public void execute(Handler<AsyncResult<R>> handler) {
            this.execute(ArrayTuple.EMPTY, handler);
        }

        @Override
        public Future<R> execute() {
            return this.execute(ArrayTuple.EMPTY);
        }

        @Override
        public void execute(Tuple args, Handler<AsyncResult<R>> handler) {
            this.execute(args, PreparedStatementImpl.this.context.promise(handler));
        }

        @Override
        public Future<R> execute(Tuple args) {
            PromiseInternal promise = PreparedStatementImpl.this.context.promise();
            this.execute(args, (Handler<AsyncResult<R>>)promise);
            return promise.future();
        }

        private void execute(Tuple args, PromiseInternal<R> promise) {
            PreparedStatementImpl.this.execute(args, 0, null, false, this.builder, promise);
        }

        @Override
        public void executeBatch(List<Tuple> argsList, Handler<AsyncResult<R>> handler) {
            this.executeBatch(argsList, PreparedStatementImpl.this.context.promise(handler));
        }

        @Override
        public Future<R> executeBatch(List<Tuple> argsList) {
            PromiseInternal promise = PreparedStatementImpl.this.context.promise();
            this.executeBatch(argsList, (Handler<AsyncResult<R>>)promise);
            return promise.future();
        }

        private void executeBatch(List<Tuple> argsList, PromiseInternal<R> promise) {
            if (argsList.isEmpty()) {
                promise.fail("Empty batch");
            } else {
                PreparedStatementImpl.this.executeBatch(argsList, this.builder, promise);
            }
        }
    }
}

