/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.data;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class Numeric
extends Number {
    public static final Numeric NaN = new Numeric(Double.NaN);
    private final Number value;

    public static Numeric create(Number number) {
        if (number == null) {
            throw new NullPointerException();
        }
        if (number instanceof Double && ((Double)number).isInfinite() || number instanceof Float && ((Float)number).isInfinite()) {
            throw new NumberFormatException("Infinite numbers are not valid numerics");
        }
        return new Numeric(number);
    }

    public static Numeric parse(String s) {
        switch (s) {
            case "NaN": {
                return NaN;
            }
        }
        return new Numeric(new BigDecimal(s));
    }

    private Numeric(Number value) {
        this.value = value;
    }

    @Override
    public short shortValue() {
        return this.value.shortValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean isNaN() {
        return this.value instanceof Double && ((Double)this.value).isNaN() || this.value instanceof Float && ((Float)this.value).isNaN();
    }

    public BigDecimal bigDecimalValue() {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        if (this.value instanceof BigInteger) {
            return new BigDecimal((BigInteger)this.value);
        }
        if (this.isNaN()) {
            return null;
        }
        return new BigDecimal(this.value.toString());
    }

    public BigInteger bigIntegerValue() {
        if (this.value instanceof BigInteger) {
            return (BigInteger)this.value;
        }
        if (this.value instanceof BigDecimal) {
            return ((BigDecimal)this.value).toBigInteger();
        }
        if (this.isNaN()) {
            return null;
        }
        return new BigInteger(Long.toString(this.value.longValue()));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Numeric) {
            Numeric that = (Numeric)obj;
            if (this.value.getClass() == that.value.getClass()) {
                return this.value.equals(that.value);
            }
            BigDecimal l = this.bigDecimalValue();
            BigDecimal r = that.bigDecimalValue();
            if (l == null) {
                return r == null;
            }
            if (r == null) {
                return false;
            }
            return l.compareTo(r) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.intValue();
    }

    public String toString() {
        return this.value.toString();
    }
}

