/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.impl.RESPEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RequestImpl
implements Request {
    private final Command cmd;
    private final List<byte[]> args;

    public RequestImpl(Command cmd) {
        this.cmd = cmd;
        this.args = cmd.getArity() != 0 ? new ArrayList<byte[]>(Math.abs(cmd.getArity())) : Collections.emptyList();
    }

    @Override
    public Command command() {
        return this.cmd;
    }

    @Override
    public Request arg(long arg) {
        this.args.add(RESPEncoder.numToBytes(arg));
        return this;
    }

    @Override
    public Request nullArg() {
        this.args.add(RESPEncoder.NULL_BULK);
        return this;
    }

    @Override
    public Request arg(byte[] arg) {
        if (arg == null) {
            return this.nullArg();
        }
        if (arg.length == 0) {
            this.args.add(RESPEncoder.EMPTY_BULK);
            return this;
        }
        this.args.add(arg);
        return this;
    }

    @Override
    public Request arg(Buffer arg) {
        if (arg == null) {
            return this.nullArg();
        }
        if (arg.length() == 0) {
            this.args.add(RESPEncoder.EMPTY_BULK);
            return this;
        }
        this.args.add(arg.getBytes());
        return this;
    }

    Buffer encode() {
        return this.encode(Buffer.buffer());
    }

    Buffer encode(Buffer buffer) {
        buffer.appendByte((byte)42).appendBytes(RESPEncoder.numToBytes(this.args.size() + 1)).appendBytes(RESPEncoder.EOL).appendBytes(this.cmd.getBytes());
        for (byte[] arg : this.args) {
            buffer.appendByte((byte)36).appendBytes(RESPEncoder.numToBytes(arg.length)).appendBytes(RESPEncoder.EOL).appendBytes(arg).appendBytes(RESPEncoder.EOL);
        }
        return buffer;
    }

    List<byte[]> getArgs() {
        return this.args;
    }

    public String toString() {
        return this.encode().toString();
    }
}

