/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import io.vertx.redis.client.impl.RedisClient;
import io.vertx.redis.client.impl.Resolver;
import io.vertx.redis.client.impl.types.ErrorType;
import java.util.List;
import java.util.Random;

public class RedisSentinelClient
implements Redis {
    private static final Random RANDOM = new Random();
    private static final Logger LOG = LoggerFactory.getLogger(RedisSentinelClient.class);
    private final Vertx vertx;
    private final RedisOptions options;
    private Redis sentinel;
    private RedisClient redis;

    private RedisSentinelClient(Vertx vertx, RedisOptions options) {
        this.vertx = vertx;
        this.options = options;
    }

    @Override
    public Redis connect(Handler<AsyncResult<Redis>> onCreate) {
        RedisSentinelClient.createClientInternal(this.vertx, this.options, RedisRole.SENTINEL, (Handler<AsyncResult<Redis>>)((Handler)create -> {
            if (create.failed()) {
                LOG.error((Object)"Redis PUB/SUB wrap failed.", create.cause());
                return;
            }
            this.sentinel = (Redis)create.result();
            this.sentinel.handler(msg -> {
                if (msg.type() == ResponseType.MULTI && "MESSAGE".equalsIgnoreCase(msg.get(0).toString())) {
                    if (this.redis != null) {
                        this.redis.fail(ErrorType.create("SWITCH-MASTER Received +switch-master message from Redis Sentinel."));
                    } else {
                        LOG.warn((Object)"Received +switch-master message from Redis Sentinel.");
                    }
                }
            });
            this.sentinel.send(Request.cmd(Command.SUBSCRIBE).arg("+switch-master"), (Handler<AsyncResult<Response>>)((Handler)send -> {
                if (send.failed()) {
                    LOG.error((Object)"Unable to subscribe to Sentinel PUBSUB", send.cause());
                    this.sentinel.close();
                }
            }));
            this.sentinel.exceptionHandler(t -> {
                LOG.error((Object)"Unhandled exception in Sentinel PUBSUB", t);
                this.sentinel.close();
            });
        }));
        RedisSentinelClient.createClientInternal(this.vertx, this.options, this.options.getRole(), (Handler<AsyncResult<Redis>>)((Handler)create -> {
            if (create.failed()) {
                onCreate.handle(create);
                return;
            }
            this.redis = (RedisClient)create.result();
            onCreate.handle((Object)Future.succeededFuture((Object)this));
        }));
        return this;
    }

    @Override
    public void close() {
        this.sentinel.close();
        this.redis.close();
    }

    @Override
    public Redis exceptionHandler(Handler<Throwable> handler) {
        this.redis.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public Redis endHandler(Handler<Void> handler) {
        this.redis.endHandler((Handler)handler);
        return this;
    }

    @Override
    public Redis handler(Handler<Response> handler) {
        this.redis.handler((Handler)handler);
        return this;
    }

    @Override
    public Redis pause() {
        this.redis.pause();
        return this;
    }

    @Override
    public Redis resume() {
        this.redis.resume();
        return null;
    }

    @Override
    public Redis send(Request command, Handler<AsyncResult<Response>> handler) {
        this.redis.send(command, handler);
        return this;
    }

    @Override
    public Redis batch(List<Request> commands, Handler<AsyncResult<List<Response>>> handler) {
        this.redis.batch(commands, handler);
        return this;
    }

    @Override
    public SocketAddress socketAddress() {
        return this.redis.socketAddress();
    }

    @Override
    public Redis fetch(long amount) {
        this.redis.fetch(amount);
        return this;
    }

    public static Redis create(Vertx vertx, RedisOptions options) {
        return new RedisSentinelClient(vertx, options);
    }

    private static void createClientInternal(Vertx vertx, RedisOptions options, RedisRole role, Handler<AsyncResult<Redis>> onCreate) {
        Handler createAndConnect = resolve -> {
            if (resolve.failed()) {
                onCreate.handle((Object)Future.failedFuture((Throwable)resolve.cause()));
                return;
            }
            RedisClient.create(vertx, options, (SocketAddress)resolve.result()).connect(onCreate);
        };
        switch (role) {
            case SENTINEL: {
                RedisSentinelClient.resolveClient(vertx, RedisSentinelClient::isSentinelOk, options, (Handler<AsyncResult<SocketAddress>>)createAndConnect);
                break;
            }
            case MASTER: {
                RedisSentinelClient.resolveClient(vertx, RedisSentinelClient::getMasterFromEndpoint, options, (Handler<AsyncResult<SocketAddress>>)createAndConnect);
                break;
            }
            case SLAVE: {
                RedisSentinelClient.resolveClient(vertx, RedisSentinelClient::getSlaveFromEndpoint, options, (Handler<AsyncResult<SocketAddress>>)createAndConnect);
            }
        }
    }

    private static void resolveClient(Vertx vertx, Resolver checkEndpointFn, RedisOptions options, Handler<AsyncResult<SocketAddress>> callback) {
        RedisSentinelClient.iterate(0, vertx, checkEndpointFn, options, (Handler<AsyncResult<Pair<Integer, SocketAddress>>>)((Handler)iterate -> {
            if (iterate.failed()) {
                callback.handle((Object)Future.failedFuture((Throwable)iterate.cause()));
            } else {
                Pair found = (Pair)iterate.result();
                List<SocketAddress> endpoints = options.getEndpoints();
                SocketAddress endpoint = endpoints.get((Integer)found.left);
                endpoints.set((Integer)found.left, endpoints.get(0));
                endpoints.set(0, endpoint);
                callback.handle((Object)Future.succeededFuture(found.right));
            }
        }));
    }

    private static void iterate(int idx, Vertx vertx, Resolver checkEndpointFn, RedisOptions argument, Handler<AsyncResult<Pair<Integer, SocketAddress>>> resultHandler) {
        List<SocketAddress> endpoints = argument.getEndpoints();
        if (idx >= endpoints.size()) {
            resultHandler.handle((Object)Future.failedFuture((String)"No more endpoints in chain."));
            return;
        }
        checkEndpointFn.resolve(vertx, endpoints.get(idx), argument, (Handler<AsyncResult<SocketAddress>>)((Handler)res -> {
            if (res.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture(new Pair<Integer, Object>(idx, res.result())));
            } else {
                RedisSentinelClient.iterate(idx + 1, vertx, checkEndpointFn, argument, resultHandler);
            }
        }));
    }

    private static void isSentinelOk(Vertx vertx, SocketAddress endpoint, RedisOptions argument, Handler<AsyncResult<SocketAddress>> handler) {
        RedisClient.create(vertx, argument, endpoint).connect((Handler<AsyncResult<Redis>>)((Handler)onCreate -> {
            if (onCreate.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)onCreate.cause()));
                return;
            }
            Redis conn = (Redis)onCreate.result();
            conn.send(Request.cmd(Command.PING), (Handler<AsyncResult<Response>>)((Handler)info -> {
                if (info.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)info.cause()));
                    return;
                }
                handler.handle((Object)Future.succeededFuture((Object)endpoint));
                conn.close();
            }));
        }));
    }

    private static void getMasterFromEndpoint(Vertx vertx, SocketAddress endpoint, RedisOptions options, Handler<AsyncResult<SocketAddress>> handler) {
        RedisClient.create(vertx, options, endpoint).connect((Handler<AsyncResult<Redis>>)((Handler)onCreate -> {
            if (onCreate.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)onCreate.cause()));
                return;
            }
            Redis conn = (Redis)onCreate.result();
            String masterName = options.getMasterName();
            conn.send(Request.cmd(Command.SENTINEL).arg("GET-MASTER-ADDR-BY-NAME").arg(masterName), (Handler<AsyncResult<Response>>)((Handler)getMasterAddrByName -> {
                if (getMasterAddrByName.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)getMasterAddrByName.cause()));
                    return;
                }
                Response response = (Response)getMasterAddrByName.result();
                handler.handle((Object)Future.succeededFuture((Object)SocketAddress.inetSocketAddress((int)response.get(1).toInteger(), (String)response.get(0).toString())));
                conn.close();
            }));
        }));
    }

    private static void getSlaveFromEndpoint(Vertx vertx, SocketAddress endpoint, RedisOptions options, Handler<AsyncResult<SocketAddress>> handler) {
        RedisClient.create(vertx, options, endpoint).connect((Handler<AsyncResult<Redis>>)((Handler)onCreate -> {
            if (onCreate.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)onCreate.cause()));
                return;
            }
            Redis conn = (Redis)onCreate.result();
            String masterName = options.getMasterName();
            conn.send(Request.cmd(Command.SENTINEL).arg("SLAVES").arg(masterName), (Handler<AsyncResult<Response>>)((Handler)sentinelSlaves -> {
                if (sentinelSlaves.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)sentinelSlaves.cause()));
                    return;
                }
                Response response = (Response)sentinelSlaves.result();
                if (response.size() == 0) {
                    handler.handle((Object)Future.failedFuture((String)("No slaves linked to the master: " + masterName)));
                } else {
                    Response slaveInfoArr = response.get(RANDOM.nextInt(response.size()));
                    if (slaveInfoArr.size() % 2 > 0) {
                        handler.handle((Object)Future.failedFuture((String)"Corrupted response from the sentinel"));
                    } else {
                        int port = 6379;
                        String ip = null;
                        for (int i = 0; i < slaveInfoArr.size(); i += 2) {
                            if ("port".equals(slaveInfoArr.get(i).toString())) {
                                port = slaveInfoArr.get(i + 1).toInteger();
                            }
                            if (!"ip".equals(slaveInfoArr.get(i).toString())) continue;
                            ip = slaveInfoArr.get(i + 1).toString();
                        }
                        if (ip == null) {
                            handler.handle((Object)Future.failedFuture((String)"No IP found for a SLAVE node!"));
                        } else {
                            handler.handle((Object)Future.succeededFuture((Object)SocketAddress.inetSocketAddress((int)port, ip)));
                        }
                    }
                }
                conn.close();
            }));
        }));
    }

    private static class Pair<L, R> {
        final L left;
        final R right;

        Pair(L left, R right) {
            this.left = left;
            this.right = right;
        }
    }
}

