/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.RedisSlaves;
import java.util.Map;

public class RedisOptionsConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, RedisOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "masterName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMasterName((String)member.getValue());
                    break;
                }
                case "maxNestedArrays": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxNestedArrays(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxWaitingHandlers": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxWaitingHandlers(((Number)member.getValue()).intValue());
                    break;
                }
                case "netClientOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setNetClientOptions(new NetClientOptions((JsonObject)member.getValue()));
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "role": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setRole(RedisRole.valueOf((String)member.getValue()));
                    break;
                }
                case "select": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setSelect(((Number)member.getValue()).intValue());
                    break;
                }
                case "type": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setType(RedisClientType.valueOf((String)member.getValue()));
                    break;
                }
                case "useSlave": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUseSlave(RedisSlaves.valueOf((String)member.getValue()));
                }
            }
        }
    }

    public static void toJson(RedisOptions obj, JsonObject json) {
        RedisOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(RedisOptions obj, Map<String, Object> json) {
        if (obj.getMasterName() != null) {
            json.put("masterName", obj.getMasterName());
        }
        json.put("maxNestedArrays", obj.getMaxNestedArrays());
        json.put("maxWaitingHandlers", obj.getMaxWaitingHandlers());
        if (obj.getNetClientOptions() != null) {
            json.put("netClientOptions", obj.getNetClientOptions().toJson());
        }
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        if (obj.getRole() != null) {
            json.put("role", obj.getRole().name());
        }
        if (obj.getSelect() != null) {
            json.put("select", obj.getSelect());
        }
        if (obj.getType() != null) {
            json.put("type", obj.getType().name());
        }
        if (obj.getUseSlave() != null) {
            json.put("useSlave", obj.getUseSlave().name());
        }
    }
}

