/*
 * Copyright (c) 2011-2013 The original author or authors
 * ------------------------------------------------------
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution.
 *
 *     The Eclipse Public License is available at
 *     http://www.eclipse.org/legal/epl-v10.html
 *
 *     The Apache License v2.0 is available at
 *     http://www.opensource.org/licenses/apache2.0.php
 *
 * You may elect to redistribute this code under either of these licenses.
 */

package io.vertx.core.file;

import io.vertx.core.VertxException;

/**
 * Exception thrown by the FileSystem class
 *
 * @author <a href="http://tfox.org">Tim Fox</a>
 */
public class FileSystemException extends VertxException {

  public FileSystemException(String message) {
    super(message);
  }

  public FileSystemException(String message, Throwable cause) {
    super(message, cause);
  }

  public FileSystemException(Throwable cause) {
    super(cause);
  }
}
