/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.Context;
import io.timeandspace.jpsg.Dimensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TemplateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TemplateProcessor.class);
    public static final int DEFAULT_PRIORITY = 0;
    private Dimensions.Parser dimensionsParser;
    private TemplateProcessor next = null;

    protected abstract void process(StringBuilder var1, Context var2, Context var3, String var4);

    protected int priority() {
        return 0;
    }

    protected final Dimensions.Parser getDimensionsParser() {
        return this.dimensionsParser;
    }

    protected final void postProcess(StringBuilder sb, Context source, Context target, String template) {
        if (this.next != null) {
            this.next.process(sb, source, target, template);
        } else {
            sb.append(template);
        }
    }

    final String generate(Context source, Context target, String template) {
        StringBuilder sb = new StringBuilder();
        this.process(sb, source, target, template);
        return sb.toString();
    }

    final void setDimensionsParser(Dimensions.Parser parser) {
        this.dimensionsParser = parser;
    }

    final void setNext(TemplateProcessor next) {
        this.next = next;
    }
}

