/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.IntermediateOption;
import io.timeandspace.jpsg.Option;
import io.timeandspace.jpsg.StringUtils;
import java.util.regex.Pattern;

public final class SimpleOption
implements Option {
    private final boolean contextOption;
    private final String opt;
    String title;
    Pattern titleP;
    String lower;
    Pattern lowerP;
    String upper;
    Pattern upperP;

    private static boolean isContextOption(String title) {
        boolean hasLow = false;
        boolean hasUp = false;
        for (int i = 0; i < title.length(); ++i) {
            char c = title.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                return true;
            }
            if (Character.isLowerCase(c)) {
                hasLow = true;
            }
            if (!Character.isUpperCase(c)) continue;
            hasUp = true;
        }
        return !hasLow || !hasUp;
    }

    public SimpleOption(String opt) {
        this.opt = opt;
        this.contextOption = SimpleOption.isContextOption(opt);
        if (this.contextOption) {
            return;
        }
        this.title = StringUtils.capitalize(opt);
        this.titleP = Pattern.compile(this.title + "(?![a-rt-z].|s[a-z])");
        this.lower = StringUtils.uncapitalize(opt);
        this.lowerP = Pattern.compile("(?<![A-Za-z])" + this.lower + "(?![a-rt-z].|s[a-z])");
        this.upper = StringUtils.toUnderscoredCase(this.title);
        this.upperP = Pattern.compile("(?<![A-Z])" + this.upper + "(?![A-RT-Z].|S[A-Z])");
    }

    @Override
    public String intermediateReplace(String content, String dim) {
        if (this.contextOption) {
            return content;
        }
        IntermediateOption intermediate = IntermediateOption.of(dim);
        content = this.lowerP.matcher(content).replaceAll(intermediate.neutralIdVariant.lower);
        content = this.titleP.matcher(content).replaceAll(intermediate.neutralIdVariant.title);
        content = this.upperP.matcher(content).replaceAll(intermediate.neutralIdVariant.upper);
        return content;
    }

    @Override
    public String finalReplace(String content, String dim) {
        if (this.contextOption) {
            return content;
        }
        IntermediateOption intermediate = IntermediateOption.of(dim);
        content = intermediate.neutralIdVariant.lowerP.matcher(content).replaceAll(this.lower);
        content = intermediate.neutralIdVariant.titleP.matcher(content).replaceAll(this.title);
        content = intermediate.neutralIdVariant.upperP.matcher(content).replaceAll(this.upper);
        return content;
    }

    @Override
    public String defaultValue() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.opt;
    }

    public int hashCode() {
        return this.opt.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SimpleOption && this.opt.equals(((SimpleOption)obj).opt);
    }
}

