/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

final class IntermediateOption {
    private static final Map<String, IntermediateOption> cache = new HashMap<String, IntermediateOption>();
    final String className;
    final Pattern classNameP;
    final String standalone;
    final Pattern standaloneP;
    final IdVariant neutralIdVariant;
    final IdVariant shortIdVariant;
    final IdVariant longIdVariant;

    public static IntermediateOption of(String dim) {
        IntermediateOption opt = cache.get(dim);
        if (opt == null) {
            opt = new IntermediateOption(dim);
            cache.put(dim, opt);
        }
        return opt;
    }

    private static String cyrillicLetters(String s) {
        return s.replace('o', '\u043e').replace('e', '\u0435').replace('a', '\u0430').replace('i', '\u0456').replace('y', '\u0443').replace('c', '\u0441').replace('p', '\u0440').replace('x', '\u0445').replace('k', '\u043a').replace('r', '\u0433');
    }

    private IntermediateOption(String dim) {
        this.className = IntermediateOption.cyrillicLetters(String.format("#%s.className#", dim));
        this.classNameP = Pattern.compile(Pattern.quote(this.className));
        this.standalone = IntermediateOption.cyrillicLetters(String.format("#%s.standalone#", dim));
        this.standaloneP = Pattern.compile(Pattern.quote(this.standalone));
        this.neutralIdVariant = new IdVariant(dim, "neutral");
        this.shortIdVariant = new IdVariant(dim, "short");
        this.longIdVariant = new IdVariant(dim, "long");
    }

    static class IdVariant {
        final String lower;
        final Pattern lowerP;
        final String title;
        final Pattern titleP;
        final String upper;
        final Pattern upperP;

        IdVariant(String dim, String idVariant) {
            this.lower = IntermediateOption.cyrillicLetters(String.format("#%s.lower.%s#", dim, idVariant));
            this.lowerP = Pattern.compile(Pattern.quote(this.lower));
            this.title = IntermediateOption.cyrillicLetters(String.format("#%s.title.%s#", dim, idVariant));
            this.titleP = Pattern.compile(Pattern.quote(this.title));
            this.upper = IntermediateOption.cyrillicLetters(String.format("#%s.upper.%s#", dim, idVariant));
            this.upperP = Pattern.compile(Pattern.quote(this.upper));
        }
    }
}

