/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.Context;
import io.timeandspace.jpsg.ObjectType;
import io.timeandspace.jpsg.Option;
import io.timeandspace.jpsg.RegexpUtils;
import io.timeandspace.jpsg.SimpleOption;
import io.timeandspace.jpsg.TemplateProcessor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class GenericsProcessor
extends TemplateProcessor {
    private static final Pattern SIMPLE_P = RegexpUtils.compile("/[*/]<>[*/]/");
    private static final Pattern SUPER_P = RegexpUtils.compile("/[*/]<super>[*/]/");
    private static final Pattern EXTENDS_P = RegexpUtils.compile("/[*/]<extends>[*/]/");
    private static final Pattern UNBOUND_P = RegexpUtils.compile("/[*/]<\\?>[*/]/");

    private static List<Map.Entry<String, Option>> getViewOptions(Context context) {
        String viewDim;
        Option viewOption;
        List<Map.Entry<String, Option>> options = new ArrayList<Map.Entry<String, Option>>();
        for (Map.Entry<String, Option> e : context) {
            options.add(e);
        }
        Option view = context.getOption("view");
        if (view != null && view instanceof SimpleOption && (viewOption = context.getOption(viewDim = ((SimpleOption)view).title.toLowerCase())) != null) {
            options = Arrays.asList(new AbstractMap.SimpleImmutableEntry<String, Option>(viewDim, viewOption));
        }
        return options;
    }

    @Override
    protected void process(StringBuilder sb, Context source, Context target, String template) {
        List<Map.Entry<String, Option>> targetOptions = GenericsProcessor.getViewOptions(target);
        String simpleG = "";
        String superG = "";
        String extendsG = "";
        String unboundG = "";
        for (Map.Entry<String, Option> e : targetOptions) {
            if (!(e.getValue() instanceof ObjectType)) continue;
            String genericParam = e.getKey().substring(0, 1).toUpperCase();
            simpleG = simpleG + ", " + genericParam;
            superG = superG + ", ? super " + genericParam;
            extendsG = extendsG + ", ? extends " + genericParam;
            unboundG = unboundG + ", ?";
        }
        if (!simpleG.isEmpty()) {
            simpleG = "<" + simpleG.substring(2) + ">";
            superG = "<" + superG.substring(2) + ">";
            extendsG = "<" + extendsG.substring(2) + ">";
            unboundG = "<" + unboundG.substring(2) + ">";
        }
        template = SIMPLE_P.matcher(template).replaceAll(simpleG);
        template = SUPER_P.matcher(template).replaceAll(superG);
        template = EXTENDS_P.matcher(template).replaceAll(extendsG);
        template = UNBOUND_P.matcher(template).replaceAll(unboundG);
        this.postProcess(sb, source, target, template);
    }
}

