/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.jpsg;

import io.timeandspace.jpsg.Context;
import io.timeandspace.jpsg.MalformedTemplateException;
import io.timeandspace.jpsg.NonexistentDimensionException;
import io.timeandspace.jpsg.ObjectType;
import io.timeandspace.jpsg.Option;
import io.timeandspace.jpsg.PrimitiveType;
import io.timeandspace.jpsg.RegexpUtils;
import io.timeandspace.jpsg.SimpleOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B!\b\u0002\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u0005J\b\u0010\u000f\u001a\u00020\u0004H\u0016R&\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/timeandspace/jpsg/Dimensions;", "", "dimensions", "Ljava/util/LinkedHashMap;", "", "", "Lio/timeandspace/jpsg/Option;", "(Ljava/util/LinkedHashMap;)V", "getDimensions$core", "()Ljava/util/LinkedHashMap;", "checkAsCondition", "", "context", "Lio/timeandspace/jpsg/Context;", "generateContexts", "toString", "Companion", "Parser", "core"})
public final class Dimensions {
    @NotNull
    private final LinkedHashMap<String, List<Option>> dimensions;
    private static final String OPTIONS = "([\\w]+)((\\|[\\w]+)+)?";
    private static final String DIMENSION = "(?<options>([\\w]+)((\\|[\\w]+)+)?)\\s+(?<dim>\\w+)";
    @NotNull
    public static final String DIMENSIONS = "(?<dimensions>(\\s*(?<options>([\\w]+)((\\|[\\w]+)+)?)\\s+(?<dim>\\w+)\\s*)+)";
    private static final Pattern DIMENSION_P;
    private static final Pattern DIMENSIONS_P;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Context> generateContexts() {
        int totalCombinations = 1;
        for (List<Option> options : this.dimensions.values()) {
            totalCombinations *= options.size();
        }
        ArrayList<Context> contexts = new ArrayList<Context>(totalCombinations);
        int n = 0;
        int n2 = totalCombinations;
        while (n < n2) {
            void comb;
            Context.Builder cb = Context.builder();
            void combRem = comb;
            for (Map.Entry<String, List<Option>> e : this.dimensions.entrySet()) {
                List<Option> options;
                Intrinsics.checkExpressionValueIsNotNull(e.getValue(), (String)"e.value");
                void index = combRem % options.size();
                combRem /= options.size();
                Option option = options.get((int)index);
                cb.put(e.getKey(), option);
            }
            contexts.add(cb.makeContext());
            ++comb;
        }
        return contexts;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkAsCondition(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = this.dimensions;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void dim;
            Option contextOption;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = (String)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            List conditionOptions = (List)entry2.getValue();
            if (conditionOptions.contains(contextOption = context.getOption((String)dim))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String toString() {
        String string = this.dimensions.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dimensions.toString()");
        return string;
    }

    @NotNull
    public final LinkedHashMap<String, List<Option>> getDimensions$core() {
        return this.dimensions;
    }

    private Dimensions(LinkedHashMap<String, List<Option>> dimensions) {
        this.dimensions = dimensions;
    }

    static {
        Companion = new Companion(null);
        DIMENSION_P = RegexpUtils.compile(DIMENSION);
        DIMENSIONS_P = RegexpUtils.compile(DIMENSIONS);
    }

    public /* synthetic */ Dimensions(LinkedHashMap dimensions, DefaultConstructorMarker $constructor_marker) {
        this(dimensions);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J2\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\t2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0015\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0018J\u0016\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/timeandspace/jpsg/Dimensions$Parser;", "", "defaultTypes", "", "Lio/timeandspace/jpsg/Option;", "(Ljava/util/List;)V", "addClassNameDim", "", "dimensions", "Ljava/util/LinkedHashMap;", "", "dim", "main", "parse", "Lio/timeandspace/jpsg/Dimensions;", "descriptor", "context", "Lio/timeandspace/jpsg/Context;", "checkContext", "", "parseCLI", "parseCLI$core", "parseClassName", "className", "parseClassName$core", "parseForCondition", "parseForContext", "Companion", "core"})
    public static final class Parser {
        private final List<Option> defaultTypes;
        public static final Companion Companion = new Companion(null);

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Dimensions parseClassName$core(@NotNull String className) {
            Object replaced;
            Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
            boolean bl = false;
            List defaultTypesFoundInClassName = new ArrayList();
            for (Option defaultType : this.defaultTypes) {
                replaced = defaultType.intermediateReplace(className, "dummy");
                String string = replaced;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"replaced");
                int firstIntermediateReplaceIndex = StringsKt.indexOf$default((CharSequence)string, (char)'#', (int)0, (boolean)false, (int)6, null);
                if (firstIntermediateReplaceIndex < 0) continue;
                defaultTypesFoundInClassName.add(new Pair((Object)defaultType, (Object)firstIntermediateReplaceIndex));
            }
            List $this$sortBy$iv = defaultTypesFoundInClassName;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                replaced = $this$sortBy$iv;
                boolean bl2 = false;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        Pair it = (Pair)a;
                        boolean bl2 = false;
                        Comparable comparable = Integer.valueOf(((Number)it.getSecond()).intValue());
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Integer n = ((Number)it.getSecond()).intValue();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                };
                CollectionsKt.sortWith((List)replaced, (Comparator)comparator);
            }
            LinkedHashMap<String, List<Option>> dimensions = new LinkedHashMap<String, List<Option>>();
            $i$f$sortBy = false;
            for (Pair typeInClassName : (Iterable)defaultTypesFoundInClassName) {
                void i;
                String string = Character.toString((char)(116 + i));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Character.toString('t' + i)");
                this.addClassNameDim(dimensions, string, (Option)typeInClassName.getFirst());
                ++i;
            }
            return new Dimensions(dimensions, null);
        }

        @NotNull
        public final Dimensions parseForContext(@NotNull String descriptor) {
            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
            try {
                return this.parse(descriptor, null, false);
            }
            catch (NonexistentDimensionException e) {
                throw (Throwable)((Object)new AssertionError((Object)e));
            }
        }

        @NotNull
        public final Dimensions parseForCondition(@NotNull String descriptor, @NotNull Context context) throws NonexistentDimensionException {
            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            return this.parse(descriptor, context, true);
        }

        private final Dimensions parse(String descriptor, Context context, boolean checkContext) throws NonexistentDimensionException {
            if (!Companion.getDIMENSIONS_P$core().matcher(descriptor).matches()) {
                throw (Throwable)MalformedTemplateException.Companion.near(descriptor, 0, "Expected a String in <dimensions> format, see the JPSG Tutorial");
            }
            Matcher m = DIMENSION_P.matcher(descriptor);
            LinkedHashMap dimensions = new LinkedHashMap();
            while (m.find()) {
                String dim = m.group("dim");
                if (checkContext) {
                    Context context2 = context;
                    if (context2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (context2.getOption(dim) == null) {
                        throw (Throwable)new NonexistentDimensionException();
                    }
                }
                String string = m.group("options");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"m.group(\"options\")");
                List<Option> opts = Companion.parseOptions$core(string);
                Map map = dimensions;
                String string2 = dim;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dim");
                map.put(string2, opts);
            }
            return new Dimensions(dimensions, null);
        }

        @NotNull
        public final Dimensions parseCLI$core(@NotNull String descriptor) {
            List list;
            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
            CharSequence charSequence = descriptor;
            String string = ",";
            int n = 0;
            string = new Regex(string);
            n = 0;
            boolean bl = false;
            List $this$dropLastWhile$iv = string.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    CharSequence charSequence2 = it;
                    boolean bl3 = false;
                    if (charSequence2.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] dimDescriptors = stringArray;
            LinkedHashMap dimensions = new LinkedHashMap();
            for (String dimDescriptor : dimDescriptors) {
                String[] parts;
                List list2;
                CharSequence charSequence3 = dimDescriptor;
                String string2 = "=";
                int n2 = 0;
                string2 = new Regex(string2);
                n2 = 0;
                boolean bl4 = false;
                List $this$dropLastWhile$iv2 = string2.split(charSequence3, n2);
                boolean $i$f$dropLastWhile2 = false;
                if (!$this$dropLastWhile$iv2.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv2.listIterator($this$dropLastWhile$iv2.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl5 = false;
                        CharSequence charSequence4 = it;
                        boolean bl6 = false;
                        if (charSequence4.length() == 0) continue;
                        list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv2, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                Collection $this$toTypedArray$iv2 = list2;
                boolean $i$f$toTypedArray2 = false;
                Collection thisCollection$iv2 = $this$toTypedArray$iv2;
                if (thisCollection$iv2.toArray(new String[0]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                ((Map)dimensions).put(parts[0], Companion.parseOptions$core(parts[1]));
            }
            return new Dimensions(dimensions, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void addClassNameDim(LinkedHashMap<String, List<Option>> dimensions, String dim, Option main) {
            void $this$filterTo$iv$iv;
            ArrayList<Option> keyOptions = new ArrayList<Option>();
            keyOptions.add(main);
            Iterable $this$filter$iv = this.defaultTypes;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Option type = (Option)element$iv$iv;
                boolean bl = false;
                if (!(!keyOptions.contains(type))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Option it = (Option)element$iv;
                boolean bl = false;
                keyOptions.add(it);
            }
            ((Map)dimensions).put(dim, keyOptions);
        }

        public Parser(@NotNull List<? extends Option> defaultTypes) {
            Intrinsics.checkParameterIsNotNull(defaultTypes, (String)"defaultTypes");
            this.defaultTypes = defaultTypes;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lio/timeandspace/jpsg/Dimensions$Parser$Companion;", "", "()V", "parseOption", "Lio/timeandspace/jpsg/Option;", "opt", "", "parseOptions", "", "options", "parseOptions$core", "core"})
        public static final class Companion {
            @NotNull
            public final List<Option> parseOptions$core(@NotNull String options) {
                List list;
                Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
                CharSequence charSequence = options;
                String string = "\\|";
                int n = 0;
                string = new Regex(string);
                n = 0;
                boolean bl = false;
                List $this$dropLastWhile$iv = string.split(charSequence, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl2 = false;
                        CharSequence charSequence2 = it;
                        boolean bl3 = false;
                        if (charSequence2.length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] opts = stringArray;
                ArrayList<Option> result = new ArrayList<Option>();
                for (String option : opts) {
                    result.add(this.parseOption(option));
                }
                return result;
            }

            private final Option parseOption(String opt) {
                Option option;
                Object object = opt;
                boolean bl = false;
                String string = object;
                if (string == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = string.toUpperCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
                String upperCaseOpt = string2;
                Map<String, PrimitiveType> map = PrimitiveType.UPPER_CASE_NAME_TO_TYPE;
                Intrinsics.checkExpressionValueIsNotNull(map, (String)"PrimitiveType.UPPER_CASE_NAME_TO_TYPE");
                object = map;
                bl = false;
                Object object2 = object;
                boolean bl2 = false;
                if (object2.containsKey(upperCaseOpt)) {
                    PrimitiveType primitiveType = PrimitiveType.UPPER_CASE_NAME_TO_TYPE.get(upperCaseOpt);
                    if (primitiveType == null) {
                        Intrinsics.throwNpe();
                    }
                    option = primitiveType;
                } else if (Intrinsics.areEqual((Object)upperCaseOpt, (Object)"OBJ") || Intrinsics.areEqual((Object)upperCaseOpt, (Object)"OBJECT")) {
                    ObjectType objectType = ObjectType.get(ObjectType.IdStyle.valueOf(upperCaseOpt));
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectType, (String)"ObjectType.get(ObjectTyp\u2026le.valueOf(upperCaseOpt))");
                    option = objectType;
                } else {
                    option = new SimpleOption(opt);
                }
                return option;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/timeandspace/jpsg/Dimensions$Companion;", "", "()V", "DIMENSION", "", "DIMENSIONS", "DIMENSIONS_P", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getDIMENSIONS_P$core", "()Ljava/util/regex/Pattern;", "DIMENSION_P", "OPTIONS", "core"})
    public static final class Companion {
        public final Pattern getDIMENSIONS_P$core() {
            return DIMENSIONS_P;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

