/*
 * Copyright 2014-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.timeandspace.jpsg;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {

    static String capitalize(String s) {
        return s.substring(0, 1).toUpperCase(Locale.ENGLISH) + s.substring(1);
    }

    static String uncapitalize(String s) {
        return s.substring(0, 1).toLowerCase(Locale.ENGLISH) + s.substring(1);
    }

    static String toUnderscoredCase(String title) {
        Matcher m = Pattern.compile("[A-Z]([a-z0-9]*+)").matcher(title);
        StringBuilder upper = new StringBuilder();
        boolean firstPart = true;
        while (m.find()) {
            upper.append(firstPart ? "" : "_").append(m.group().toUpperCase());
            firstPart = false;
        }
        return upper.toString();
    }

    private StringUtils() {}
}
