/*
 * Decompiled with CFR 0.152.
 */
package io.socket.socketio.server;

import io.socket.emitter.Emitter;
import io.socket.socketio.server.SocketIoNamespace;
import io.socket.socketio.server.SocketIoNamespaceImpl;
import io.socket.socketio.server.SocketIoServer;
import io.socket.socketio.server.SocketIoSocket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

final class SocketIoNamespaceGroupImpl
extends SocketIoNamespace {
    private static final AtomicInteger NAME_COUNTER = new AtomicInteger(0);
    private final HashSet<SocketIoNamespaceImpl> mChildNamespaces = new HashSet();

    SocketIoNamespaceGroupImpl(SocketIoServer server) {
        super(server, "/_" + NAME_COUNTER.incrementAndGet());
    }

    @Override
    public void broadcast(String[] rooms, String event, Object[] args) throws IllegalArgumentException {
        for (SocketIoNamespaceImpl namespace : this.mChildNamespaces) {
            namespace.broadcast(rooms, event, args);
        }
    }

    @Override
    Map<String, SocketIoSocket> getConnectedSockets() {
        HashMap<String, SocketIoSocket> sockets = new HashMap<String, SocketIoSocket>();
        for (SocketIoNamespaceImpl namespace : this.mChildNamespaces) {
            sockets.putAll(namespace.getConnectedSockets());
        }
        return sockets;
    }

    SocketIoNamespaceImpl createChild(String name) {
        SocketIoNamespaceImpl nsp = new SocketIoNamespaceImpl(this.getServer(), name);
        for (Emitter.Listener listener : this.listeners("connect")) {
            nsp.on("connect", listener);
        }
        for (Emitter.Listener listener : this.listeners("connection")) {
            nsp.on("connection", listener);
        }
        this.mChildNamespaces.add(nsp);
        return nsp;
    }
}

