/*
 * Decompiled with CFR 0.152.
 */
package io.socket.yeast;

import java.security.SecureRandom;

public final class ServerYeast {
    private static final ThreadLocal<SecureRandom> THREAD_RANDOM = new ThreadLocal();
    private static final char[] alphabet = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_".toCharArray();

    public static String yeast() {
        SecureRandom secureRandom = THREAD_RANDOM.get();
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
            THREAD_RANDOM.set(secureRandom);
        }
        return ServerYeast.encode(secureRandom.nextLong() & Long.MAX_VALUE);
    }

    public static String encode(long num) {
        StringBuilder encoded = new StringBuilder();
        long dividedNum = num;
        do {
            encoded.insert(0, alphabet[(int)(dividedNum % (long)alphabet.length)]);
        } while ((dividedNum /= (long)alphabet.length) > 0L);
        return encoded.toString();
    }
}

