/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.parser;

import io.socket.engineio.parser.Packet;
import io.socket.engineio.parser.ParserV3;
import io.socket.engineio.parser.ParserV4;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface Parser {
    public static final Map<String, Integer> PACKETS = Collections.unmodifiableMap(new HashMap<String, Integer>(){
        {
            this.put("open", 0);
            this.put("close", 1);
            this.put("ping", 2);
            this.put("pong", 3);
            this.put("message", 4);
            this.put("upgrade", 5);
            this.put("noop", 6);
        }
    });
    public static final Map<Integer, String> PACKETS_REVERSE = Collections.unmodifiableMap(new HashMap<Integer, String>(){
        {
            this.put(0, "open");
            this.put(1, "close");
            this.put(2, "ping");
            this.put(3, "pong");
            this.put(4, "message");
            this.put(5, "upgrade");
            this.put(6, "noop");
        }
    });
    public static final Packet<String> ERROR_PACKET = new Packet<String>("error", "parser error");
    public static final Parser PROTOCOL_V3 = new ParserV3();
    public static final Parser PROTOCOL_V4 = new ParserV4();

    public int getProtocolVersion();

    public void encodePacket(Packet<?> var1, boolean var2, EncodeCallback<Object> var3);

    public Packet<?> decodePacket(Object var1);

    public void encodePayload(List<Packet<?>> var1, boolean var2, EncodeCallback<Object> var3);

    public void decodePayload(Object var1, DecodePayloadCallback<Object> var2);

    public static interface DecodePayloadCallback<T> {
        public boolean call(Packet<T> var1, int var2, int var3);
    }

    public static interface EncodeCallback<T> {
        public void call(T var1);
    }
}

