/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server;

import io.socket.emitter.Emitter;
import io.socket.engineio.server.EngineIoServerOptions;
import io.socket.engineio.server.EngineIoSocket;
import io.socket.engineio.server.EngineIoWebSocket;
import io.socket.engineio.server.ServerErrors;
import io.socket.engineio.server.Transport;
import io.socket.engineio.server.transport.Polling;
import io.socket.engineio.server.transport.WebSocket;
import io.socket.parseqs.ParseQS;
import io.socket.yeast.ServerYeast;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONObject;

public final class EngineIoServer
extends Emitter {
    private final Map<String, EngineIoSocket> mClients = new ConcurrentHashMap<String, EngineIoSocket>();
    private final EngineIoServerOptions mOptions;
    private final ScheduledExecutorService mScheduledExecutor;

    public EngineIoServer() {
        this(EngineIoServerOptions.DEFAULT);
    }

    public EngineIoServer(EngineIoServerOptions options) {
        this.mOptions = options;
        this.mOptions.lock();
        this.mScheduledExecutor = Executors.newScheduledThreadPool(this.mOptions.getMaxTimeoutThreadPoolSize(), new ThreadFactory(){
            private final AtomicLong mThreadCount = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName(String.format("engineIo-threadPool-%d", this.mThreadCount.incrementAndGet()));
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public EngineIoServerOptions getOptions() {
        return this.mOptions;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.mScheduledExecutor;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map query = ParseQS.decode((String)request.getQueryString());
        request.setAttribute("query", (Object)query);
        if (!this.mOptions.isCorsHandlingDisabled()) {
            boolean sendCors;
            String origin = request.getHeader("Origin");
            boolean bl = sendCors = origin != null && (this.mOptions.getAllowedCorsOrigins() == EngineIoServerOptions.ALLOWED_CORS_ORIGIN_ALL || Arrays.binarySearch(this.mOptions.getAllowedCorsOrigins(), origin) >= 0);
            if (sendCors) {
                response.addHeader("Access-Control-Allow-Origin", origin);
                response.addHeader("Access-Control-Allow-Credentials", "true");
                response.addHeader("Access-Control-Allow-Methods", "GET,HEAD,PUT,PATCH,POST,DELETE");
                response.addHeader("Access-Control-Allow-Headers", "origin, content-type, accept");
            }
        }
        if (!query.containsKey("transport") || !((String)query.get("transport")).equals("polling")) {
            this.sendErrorMessage(response, ServerErrors.UNKNOWN_TRANSPORT);
            return;
        }
        String sid = (String)query.get("sid");
        if (sid != null) {
            if (!this.mClients.containsKey(query.get("sid"))) {
                this.sendErrorMessage(response, ServerErrors.UNKNOWN_SID);
            } else if (!query.containsKey("transport") || !((String)query.get("transport")).equals(this.mClients.get(sid).getCurrentTransportName())) {
                this.sendErrorMessage(response, ServerErrors.BAD_REQUEST);
            } else {
                this.mClients.get(sid).onRequest(request, response);
            }
        } else if (!request.getMethod().equalsIgnoreCase("GET")) {
            this.sendErrorMessage(response, ServerErrors.BAD_HANDSHAKE_METHOD);
        } else {
            this.handshakePolling(request, response);
        }
    }

    public void handleWebSocket(EngineIoWebSocket webSocket) {
        Map<String, String> query = webSocket.getQuery();
        String sid = query.get("sid");
        if (sid != null) {
            EngineIoSocket socket = this.mClients.get(sid);
            if (socket == null) {
                webSocket.close();
            } else if (!socket.canUpgrade("websocket")) {
                webSocket.close();
            } else {
                WebSocket transport = new WebSocket(webSocket);
                socket.upgrade(transport);
            }
        } else {
            this.handshakeWebSocket(webSocket);
        }
    }

    private void sendErrorMessage(HttpServletResponse response, ServerErrors code) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        if (code != null) {
            response.setStatus(400);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", code.getCode());
            jsonObject.put("message", (Object)code.getMessage());
            response.getWriter().write(jsonObject.toString());
        } else {
            response.setStatus(403);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", ServerErrors.FORBIDDEN.getCode());
            jsonObject.put("message", (Object)ServerErrors.FORBIDDEN.getMessage());
            response.getWriter().write(jsonObject.toString());
        }
    }

    private void handshakePolling(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String sid = ServerYeast.yeast();
        Object lockObject = new Object();
        EngineIoSocket socket = new EngineIoSocket(lockObject, sid, this, this.mScheduledExecutor);
        Polling transport = new Polling(lockObject);
        socket.init(transport, request);
        ((Transport)transport).onRequest(request, response);
        socket.updateInitialHeadersFromActiveTransport();
        this.mClients.put(sid, socket);
        socket.once("close", args -> this.mClients.remove(sid));
        this.emit("connection", new Object[]{socket});
    }

    private void handshakeWebSocket(EngineIoWebSocket webSocket) {
        String sid = ServerYeast.yeast();
        WebSocket transport = new WebSocket(webSocket);
        EngineIoSocket socket = new EngineIoSocket(new Object(), sid, this, this.mScheduledExecutor);
        socket.init(transport, null);
        this.mClients.put(sid, socket);
        socket.once("close", args -> this.mClients.remove(sid));
        this.emit("connection", new Object[]{socket});
    }
}

