/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server;

import io.socket.emitter.Emitter;
import io.socket.engineio.parser.Packet;
import io.socket.engineio.server.EngineIoServer;
import io.socket.engineio.server.EngineIoSocketTimeoutHandler;
import io.socket.engineio.server.ReadyState;
import io.socket.engineio.server.Transport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public final class EngineIoSocket
extends Emitter {
    private static final List<Packet<?>> PAYLOAD_NOOP = new ArrayList<Packet<?>>(){
        {
            this.add(new Packet("noop"));
        }
    };
    private final String mSid;
    private final EngineIoServer mServer;
    private final LinkedList<Packet<?>> mWriteBuffer = new LinkedList();
    private final Runnable mPingTimeoutTask = () -> this.onClose("ping timeout", null);
    private final Object mLockObject;
    private final EngineIoSocketTimeoutHandler mPingTimeoutHandler;
    private ScheduledFuture<?> mPingTimerScheduledReference = null;
    private Runnable mCleanupFunction = null;
    private ReadyState mReadyState;
    private Transport mTransport;
    private AtomicBoolean mUpgrading = new AtomicBoolean(false);

    EngineIoSocket(Object lockObject, String sid, EngineIoServer server, EngineIoSocketTimeoutHandler pingTimeoutHandler) {
        this.mLockObject = lockObject;
        this.mSid = sid;
        this.mServer = server;
        this.mPingTimeoutHandler = pingTimeoutHandler;
        this.mReadyState = ReadyState.OPENING;
    }

    public String getId() {
        return this.mSid;
    }

    public ReadyState getReadyState() {
        return this.mReadyState;
    }

    public void send(Packet<?> packet) {
        this.sendPacket(packet);
    }

    public void close() {
        if (this.mReadyState == ReadyState.OPEN) {
            this.mReadyState = ReadyState.CLOSING;
            if (this.mWriteBuffer.size() > 0) {
                this.mTransport.on("drain", args -> this.closeTransport());
            } else {
                this.closeTransport();
            }
        }
    }

    void init(Transport transport, HttpServletRequest initialRequest) {
        this.setTransport(transport);
        this.onOpen();
    }

    void onRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.mTransport.onRequest(request, response);
        if (this.mUpgrading.get() && this.mTransport.isWritable() && this.mWriteBuffer.isEmpty()) {
            this.mTransport.send(PAYLOAD_NOOP);
        }
    }

    boolean canUpgrade(String transport) {
        return !this.mUpgrading.get() && this.mTransport.getName().equals("polling") && transport.equals("websocket");
    }

    void upgrade(Transport transport) {
        this.mUpgrading.set(true);
        Runnable cleanup = () -> {
            this.mUpgrading.set(false);
            transport.off("packet");
            transport.off("close");
            transport.off("error");
        };
        Emitter.Listener onError = args -> {
            cleanup.run();
            transport.close();
        };
        transport.on("packet", args -> {
            Packet packet = (Packet)args[0];
            if (packet.type.equals("ping") && packet.data != null && packet.data.equals("probe")) {
                final Packet replyPacket = new Packet("pong");
                replyPacket.data = "probe";
                transport.send(new ArrayList<Packet<?>>(){
                    {
                        this.add(replyPacket);
                    }
                });
                if (this.mTransport.isWritable()) {
                    this.mTransport.send(PAYLOAD_NOOP);
                }
                this.emit("upgrading", new Object[]{transport});
            } else if (packet.type.equals("upgrade") && this.mReadyState != ReadyState.CLOSED && this.mReadyState != ReadyState.CLOSING) {
                cleanup.run();
                this.clearTransport();
                this.setTransport(transport);
                this.emit("upgrade", new Object[]{transport});
                this.flush();
                this.resetPingTimeout();
            } else {
                cleanup.run();
                transport.close();
            }
        });
        transport.once("close", args -> onError.call(new Object[]{"transport closed"}));
        transport.once("error", onError);
        this.once("close", args -> onError.call(new Object[]{"socket closed"}));
    }

    String getCurrentTransportName() {
        return this.mTransport.getName();
    }

    private void setTransport(Transport transport) {
        this.mTransport = transport;
        transport.once("error", args -> this.onError());
        transport.once("close", args -> {
            String description = args.length > 0 ? (String)args[0] : null;
            this.onClose("transport close", description);
        });
        transport.on("packet", args -> this.onPacket((Packet)args[0]));
        transport.on("drain", args -> this.flush());
        this.mCleanupFunction = () -> {
            transport.off("error");
            transport.off("close");
            transport.off("packet");
            transport.off("drain");
        };
    }

    private void closeTransport() {
        this.mTransport.close();
    }

    private void clearTransport() {
        if (this.mCleanupFunction != null) {
            this.mCleanupFunction.run();
        }
        this.mTransport.close();
    }

    private void onOpen() {
        this.mReadyState = ReadyState.OPEN;
        JSONArray upgrades = new JSONArray();
        upgrades.put((Object)"websocket");
        JSONObject handshakePacket = new JSONObject();
        handshakePacket.put("sid", (Object)this.mSid);
        handshakePacket.put("upgrades", (Object)upgrades);
        handshakePacket.put("pingInterval", this.mServer.getOptions().getPingInterval());
        handshakePacket.put("pingTimeout", this.mServer.getOptions().getPingTimeout());
        Packet openPacket = new Packet("open");
        openPacket.data = handshakePacket.toString();
        this.sendPacket(openPacket);
        if (this.mServer.getOptions().getInitialPacket() != null) {
            this.sendPacket(this.mServer.getOptions().getInitialPacket());
        }
        this.emit("open", new Object[0]);
        this.resetPingTimeout();
    }

    private void onClose(String reason, String description) {
        if (this.mReadyState != ReadyState.CLOSED) {
            this.mReadyState = ReadyState.CLOSED;
            this.mPingTimerScheduledReference.cancel(false);
            this.clearTransport();
            this.emit("close", new Object[]{reason, description});
        }
    }

    private void onError() {
        this.onClose("transport error", null);
    }

    private void onPacket(Packet<?> packet) {
        if (this.mReadyState == ReadyState.OPEN) {
            this.emit("packet", new Object[]{packet});
            this.resetPingTimeout();
            switch (packet.type) {
                case "ping": {
                    this.sendPacket(new Packet("pong"));
                    this.emit("heartbeat", new Object[0]);
                    break;
                }
                case "error": {
                    this.onClose("parse error", null);
                    break;
                }
                case "message": {
                    this.emit("data", new Object[]{packet.data});
                    this.emit("message", new Object[]{packet.data});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPacket(Packet<?> packet) {
        if (this.mReadyState != ReadyState.CLOSING && this.mReadyState != ReadyState.CLOSED) {
            Object object = this.mLockObject;
            synchronized (object) {
                this.mWriteBuffer.add(packet);
            }
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        if (this.mReadyState != ReadyState.CLOSED && this.mTransport.isWritable() && this.mWriteBuffer.size() > 0) {
            Object object = this.mLockObject;
            synchronized (object) {
                this.emit("flush", new Object[]{Collections.unmodifiableCollection(this.mWriteBuffer)});
                this.mTransport.send(this.mWriteBuffer);
                this.mWriteBuffer.clear();
            }
            this.emit("drain", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPingTimeout() {
        Object object = this.mLockObject;
        synchronized (object) {
            if (this.mPingTimerScheduledReference != null) {
                this.mPingTimerScheduledReference.cancel(false);
            }
            this.mPingTimerScheduledReference = this.mPingTimeoutHandler.schedule(this.mPingTimeoutTask, this.mServer.getOptions().getPingInterval() + this.mServer.getOptions().getPingTimeout(), TimeUnit.MILLISECONDS);
        }
    }
}

