/*
 * Decompiled with CFR 0.152.
 */
package io.socket.emitter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public class Emitter {
    private ConcurrentMap<String, ConcurrentLinkedQueue<Listener>> callbacks = new ConcurrentHashMap<String, ConcurrentLinkedQueue<Listener>>();

    public Emitter on(String event, Listener fn) {
        ConcurrentLinkedQueue tempCallbacks;
        ConcurrentLinkedQueue<Listener> callbacks = (ConcurrentLinkedQueue<Listener>)this.callbacks.get(event);
        if (callbacks == null && (tempCallbacks = this.callbacks.putIfAbsent(event, callbacks = new ConcurrentLinkedQueue<Listener>())) != null) {
            callbacks = tempCallbacks;
        }
        callbacks.add(fn);
        return this;
    }

    public Emitter once(String event, Listener fn) {
        this.on(event, new OnceListener(event, fn));
        return this;
    }

    public Emitter off() {
        this.callbacks.clear();
        return this;
    }

    public Emitter off(String event) {
        this.callbacks.remove(event);
        return this;
    }

    public Emitter off(String event, Listener fn) {
        ConcurrentLinkedQueue callbacks = (ConcurrentLinkedQueue)this.callbacks.get(event);
        if (callbacks != null) {
            Iterator it = callbacks.iterator();
            while (it.hasNext()) {
                Listener internal = (Listener)it.next();
                if (!Emitter.sameAs(fn, internal)) continue;
                it.remove();
                break;
            }
        }
        return this;
    }

    private static boolean sameAs(Listener fn, Listener internal) {
        if (fn.equals(internal)) {
            return true;
        }
        if (internal instanceof OnceListener) {
            return fn.equals(((OnceListener)internal).fn);
        }
        return false;
    }

    public Emitter emit(String event, Object ... args) {
        ConcurrentLinkedQueue callbacks = (ConcurrentLinkedQueue)this.callbacks.get(event);
        if (callbacks != null) {
            for (Listener fn : callbacks) {
                fn.call(args);
            }
        }
        return this;
    }

    public List<Listener> listeners(String event) {
        ConcurrentLinkedQueue callbacks = (ConcurrentLinkedQueue)this.callbacks.get(event);
        return callbacks != null ? new ArrayList<Listener>(callbacks) : new ArrayList(0);
    }

    public boolean hasListeners(String event) {
        ConcurrentLinkedQueue callbacks = (ConcurrentLinkedQueue)this.callbacks.get(event);
        return callbacks != null && !callbacks.isEmpty();
    }

    private class OnceListener
    implements Listener {
        public final String event;
        public final Listener fn;

        public OnceListener(String event, Listener fn) {
            this.event = event;
            this.fn = fn;
        }

        @Override
        public void call(Object ... args) {
            Emitter.this.off(this.event, this);
            this.fn.call(args);
        }
    }

    public static interface Listener {
        public void call(Object ... var1);
    }
}

