package io.vertx.mutiny.sqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A row oriented stream.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.RowStream original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.sqlclient.RowStream.class)
public class RowStream<T> implements io.vertx.mutiny.core.streams.ReadStream<T> {

  public static final io.smallrye.mutiny.vertx.TypeArg<RowStream> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new RowStream((io.vertx.sqlclient.RowStream) obj),
    RowStream::getDelegate
  );

  private final io.vertx.sqlclient.RowStream<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public RowStream(io.vertx.sqlclient.RowStream delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public RowStream(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.sqlclient.RowStream)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public RowStream(io.vertx.sqlclient.RowStream delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  RowStream() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.sqlclient.RowStream getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RowStream that = (RowStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public io.vertx.mutiny.core.streams.Pipe<T> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<T> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), __typeArg_0);
    return ret;
  }

  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<T> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<T> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<T> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @Fluent
  private io.vertx.mutiny.sqlclient.RowStream<T> __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.sqlclient.RowStream<T> exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  @Fluent
  private io.vertx.mutiny.sqlclient.RowStream<T> __handler(Handler<T> handler) { 
    delegate.handler(new Handler<T>() {
      public void handle(T event) {
        handler.handle((T)__typeArg_0.wrap(event));
      }
    });
    return this;
  }

  public io.vertx.mutiny.sqlclient.RowStream<T> handler(java.util.function.Consumer<T> handler) {
    return __handler(handler != null ? handler::accept : null);
  }

  @Fluent
  public io.vertx.mutiny.sqlclient.RowStream<T> pause() { 
    delegate.pause();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.sqlclient.RowStream<T> resume() { 
    delegate.resume();
    return this;
  }

  @Fluent
  private io.vertx.mutiny.sqlclient.RowStream<T> __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.sqlclient.RowStream<T> endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  @Fluent
  public io.vertx.mutiny.sqlclient.RowStream<T> fetch(long l) { 
    delegate.fetch(l);
    return this;
  }

  /**
   * Close the stream and release the resources.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.close(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.RowStream#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.RowStream#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.RowStream#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.RowStream#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  private Multi<T> multi;
  public synchronized Multi<T> toMulti() {
    if (multi == null) {
      java.util.function.Function<T, T> conv = (java.util.function.Function<T, T>) __typeArg_0.wrap;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<T> toBlockingIterable() {
    return toMulti().subscribe().asIterable();  }

  public java.util.stream.Stream<T> toBlockingStream() {
    return toMulti().subscribe().asStream();  }

  public static <T>RowStream<T> newInstance(io.vertx.sqlclient.RowStream arg) {
    return arg != null ? new RowStream<T>(arg) : null;
  }


  public static <T>RowStream<T> newInstance(io.vertx.sqlclient.RowStream arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new RowStream<T>(arg, __typeArg_T) : null;
  }

}
