package io.vertx.mutiny.sqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import java.util.List;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;
import java.util.function.Function;

/**
 * A query for a prepared statement allowing parameterized execution of the query, this query will use
 * a prepared statement.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.PreparedQuery original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.sqlclient.PreparedQuery.class)
public class PreparedQuery<T> extends io.vertx.mutiny.sqlclient.Query<T> {

  public static final io.smallrye.mutiny.vertx.TypeArg<PreparedQuery> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new PreparedQuery((io.vertx.sqlclient.PreparedQuery) obj),
    PreparedQuery::getDelegate
  );

  private final io.vertx.sqlclient.PreparedQuery<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public PreparedQuery(io.vertx.sqlclient.PreparedQuery delegate) {
    super(delegate);
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public PreparedQuery(Object delegate, TypeArg<T> typeArg_0) {
    super((io.vertx.sqlclient.PreparedQuery)delegate);
    this.delegate = (io.vertx.sqlclient.PreparedQuery)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public PreparedQuery(io.vertx.sqlclient.PreparedQuery delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    super(delegate);
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  PreparedQuery() {
    super(null);
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.sqlclient.PreparedQuery getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PreparedQuery that = (PreparedQuery) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Execute the query.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public io.smallrye.mutiny.Uni<T> execute() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.execute(new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((T)__typeArg_0.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.Query#execute}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the T instance produced by the operation.
   */
  public T executeAndAwait() { 
    return (T) execute().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.Query#execute} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.Query#execute}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.Query#execute} but you don't need to compose it with other operations.
   */
  public void executeAndForget() { 
    execute().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Execute the query.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param tuple 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public io.smallrye.mutiny.Uni<T> execute(io.vertx.mutiny.sqlclient.Tuple tuple) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.execute(tuple.getDelegate(), new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((T)__typeArg_0.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.PreparedQuery#execute(io.vertx.mutiny.sqlclient.Tuple)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param tuple 
   * @return the T instance produced by the operation.
   */
  public T executeAndAwait(io.vertx.mutiny.sqlclient.Tuple tuple) { 
    return (T) execute(tuple).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.PreparedQuery#execute(io.vertx.mutiny.sqlclient.Tuple)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.PreparedQuery#execute(io.vertx.mutiny.sqlclient.Tuple)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.PreparedQuery#execute(io.vertx.mutiny.sqlclient.Tuple)} but you don't need to compose it with other operations.
   * @param tuple 
   */
  public void executeAndForget(io.vertx.mutiny.sqlclient.Tuple tuple) { 
    execute(tuple).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Execute the query with a batch of tuples.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param batch the batch of tuples
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public io.smallrye.mutiny.Uni<T> executeBatch(List<io.vertx.mutiny.sqlclient.Tuple> batch) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.executeBatch(batch.stream().map(elt -> elt.getDelegate()).collect(java.util.stream.Collectors.toList()), new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((T)__typeArg_0.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.PreparedQuery#executeBatch(List<Tuple>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param batch the batch of tuples
   * @return the T instance produced by the operation.
   */
  public T executeBatchAndAwait(List<io.vertx.mutiny.sqlclient.Tuple> batch) { 
    return (T) executeBatch(batch).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.PreparedQuery#executeBatch(List<Tuple>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.PreparedQuery#executeBatch(List<Tuple>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.PreparedQuery#executeBatch(List<Tuple>)} but you don't need to compose it with other operations.
   * @param batch the batch of tuples
   */
  public void executeBatchAndForget(List<io.vertx.mutiny.sqlclient.Tuple> batch) { 
    executeBatch(batch).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param mapper 
   * @return 
   */
  public <U> io.vertx.mutiny.sqlclient.PreparedQuery<io.vertx.mutiny.sqlclient.RowSet<U>> mapping(Function<io.vertx.mutiny.sqlclient.Row, U> mapper) { 
    io.vertx.mutiny.sqlclient.PreparedQuery<io.vertx.mutiny.sqlclient.RowSet<U>> ret = io.vertx.mutiny.sqlclient.PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)delegate.mapping(new java.util.function.Function<io.vertx.sqlclient.Row,U>() {
      public U apply(io.vertx.sqlclient.Row arg) {
        U ret = mapper.apply(io.vertx.mutiny.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)arg));
        return ret;
      }
    }), new TypeArg<io.vertx.mutiny.sqlclient.RowSet<U>>(o0 -> io.vertx.mutiny.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o0, TypeArg.unknown()), o0 -> o0.getDelegate()));
    return ret;
  }

  public static <T>PreparedQuery<T> newInstance(io.vertx.sqlclient.PreparedQuery arg) {
    return arg != null ? new PreparedQuery<T>(arg) : null;
  }


  public static <T>PreparedQuery<T> newInstance(io.vertx.sqlclient.PreparedQuery arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new PreparedQuery<T>(arg, __typeArg_T) : null;
  }

}
