/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.validator;

import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.ConstraintValidator;

public class URLEncodedConstraintValidator
implements ConstraintValidator<String> {
    private static final int MAX_ASCII_CODE = 127;

    @Override
    public void validate(String actual, HttpModelType httpModelType, String modelName) {
        if (actual != null) {
            for (int i = 0; i < actual.length(); ++i) {
                char ch = actual.charAt(i);
                if (ch <= '\u007f') continue;
                throw new ValidationException("Invalid ? \"?\": Expected a URL encoded string, where all characters are between 0x00 and 0x7F (ASCII), but actual is '?'. Invalid character is '?' (0x?)!", new Object[]{httpModelType, modelName, actual, Character.valueOf(ch), Integer.toHexString(ch)});
            }
        }
    }
}

