/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.validator;

import io.rxmicro.common.ImpossibleException;
import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.ConstraintValidator;
import io.rxmicro.validation.base.AbstractDateTimeEqualsConstraintValidator;
import io.rxmicro.validation.constraint.TruncatedTime;
import java.time.Instant;

public class TruncatedTimeInstantConstraintValidator
extends AbstractDateTimeEqualsConstraintValidator
implements ConstraintValidator<Instant> {
    private static final String ERROR_MESSAGE_TEMPLATE = "Invalid ? \"?\": Expected a time without ?, but actual is '?'!";
    private final TruncatedTime.Truncated truncated;

    public TruncatedTimeInstantConstraintValidator(TruncatedTime.Truncated truncated) {
        this.truncated = truncated;
    }

    @Override
    public void validate(Instant actual, HttpModelType httpModelType, String modelName) {
        if (actual != null) {
            long instantMillis = actual.toEpochMilli();
            if (this.truncated == TruncatedTime.Truncated.MILLIS) {
                if (!this.isTruncatedToMillis(instantMillis)) {
                    throw new ValidationException(ERROR_MESSAGE_TEMPLATE, new Object[]{httpModelType, modelName, "milli seconds", actual});
                }
            } else if (this.truncated == TruncatedTime.Truncated.SECONDS) {
                if (!this.isTruncatedToSeconds(instantMillis)) {
                    throw new ValidationException(ERROR_MESSAGE_TEMPLATE, new Object[]{httpModelType, modelName, "seconds", actual});
                }
            } else if (this.truncated == TruncatedTime.Truncated.MINUTES) {
                if (!this.isTruncatedToMinutes(instantMillis)) {
                    throw new ValidationException(ERROR_MESSAGE_TEMPLATE, new Object[]{httpModelType, modelName, "minutes", actual});
                }
            } else if (this.truncated == TruncatedTime.Truncated.HOURS) {
                if (!this.isTruncatedToHour(instantMillis)) {
                    throw new ValidationException(ERROR_MESSAGE_TEMPLATE, new Object[]{httpModelType, modelName, "hours", actual});
                }
            } else {
                throw new ImpossibleException("Unsupported truncated: ?", new Object[]{this.truncated});
            }
        }
    }

    private boolean isTruncatedToMillis(long instant) {
        return instant % 1000L == 0L;
    }

    private boolean isTruncatedToSeconds(long instant) {
        return instant % 60000L == 0L;
    }

    private boolean isTruncatedToMinutes(long instant) {
        return instant % 3600000L == 0L;
    }

    private boolean isTruncatedToHour(long instant) {
        return instant % 86400000L == 0L;
    }
}

