/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.validator;

import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.ConstraintValidator;
import io.rxmicro.validation.base.ParametrizedConstraintValidator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@ParametrizedConstraintValidator
public class SubEnumConstraintValidator<T extends Enum<T>>
implements ConstraintValidator<T> {
    private final Set<String> allowed = new HashSet<String>();

    public SubEnumConstraintValidator(Class<T> enumClass, List<String> include, List<String> exclude) {
        if (!include.isEmpty()) {
            for (Enum en : (Enum[])enumClass.getEnumConstants()) {
                if (!include.contains(en.name())) continue;
                this.allowed.add(en.name());
            }
        }
        if (!exclude.isEmpty()) {
            for (Enum en : (Enum[])enumClass.getEnumConstants()) {
                if (exclude.contains(en.name())) continue;
                this.allowed.add(en.name());
            }
        }
    }

    @Override
    public void validate(T actual, HttpModelType httpModelType, String modelName) {
        if (actual != null && !this.allowed.contains(((Enum)actual).name())) {
            throw new ValidationException("Invalid ? \"?\": Expected a value from the set ?, but actual is '?'!", new Object[]{httpModelType, modelName, this.allowed, actual});
        }
    }
}

