/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.validator;

import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.base.AbstractContainerConstraintValidator;
import java.util.List;

public class SizeListConstraintValidator
extends AbstractContainerConstraintValidator<List<?>> {
    private final int expectedSize;

    public SizeListConstraintValidator(int expectedSize) {
        this.expectedSize = expectedSize;
    }

    @Override
    public void validate(List<?> value, HttpModelType httpModelType, String modelName) {
        int actual;
        if (value != null && (actual = value.size()) != this.expectedSize) {
            throw new ValidationException("Invalid ? \"?\": Expected array length = ?, but actual is ?. (array: ?)!", new Object[]{httpModelType, modelName, this.expectedSize, actual, value});
        }
    }
}

