/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.validator;

import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.ConstraintValidator;

public class PhoneConstraintValidator
implements ConstraintValidator<String> {
    private final boolean withoutPlus;
    private final boolean allowsSpaces;

    public PhoneConstraintValidator(boolean withoutPlus, boolean allowsSpaces) {
        this.withoutPlus = withoutPlus;
        this.allowsSpaces = allowsSpaces;
    }

    @Override
    public void validate(String actual, HttpModelType httpModelType, String modelName) {
        if (actual != null && actual.length() > 0) {
            String validValue = this.allowsSpaces ? actual.trim() : actual;
            this.validatePlusChar(validValue, httpModelType, modelName, this.withoutPlus);
            this.validateDigitsOnly(validValue, httpModelType, modelName);
        }
    }

    private void validatePlusChar(CharSequence phone, HttpModelType httpModelType, String fieldName, boolean withoutPlus) {
        if (withoutPlus) {
            if (phone.charAt(0) == '+') {
                throw new ValidationException("Invalid ? \"?\": Expected a digit as a first character, but actual is '+'!", new Object[]{httpModelType, fieldName});
            }
        } else if (phone.charAt(0) != '+') {
            throw new ValidationException("Invalid ? \"?\": Expected a plus as a first character, but actual is '?'!", new Object[]{httpModelType, fieldName, Character.valueOf(phone.charAt(0))});
        }
    }

    private void validateDigitsOnly(CharSequence phone, HttpModelType httpModelType, String fieldName) {
        int i;
        int n = i = this.withoutPlus ? 0 : 1;
        while (i < phone.length()) {
            char ch = phone.charAt(i);
            if (!(Character.isDigit(ch) || this.allowsSpaces && Character.isWhitespace(ch))) {
                throw new ValidationException("Invalid ? \"?\": Expected digits only, but actual is '?' and contains invalid character: '?' (0x?)!", new Object[]{httpModelType, fieldName, phone, Character.valueOf(ch), Integer.toHexString(ch)});
            }
            ++i;
        }
    }
}

