/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.validator;

import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.ConstraintValidator;
import io.rxmicro.validation.constraint.Pattern;
import java.util.Collection;
import java.util.regex.Pattern;

public class PatternConstraintValidator
implements ConstraintValidator<String> {
    private final Pattern pattern;
    private final String regexp;

    public PatternConstraintValidator(String regex, Collection<Pattern.Flag> flags) {
        this.pattern = Pattern.compile(regex, flags.stream().map(Pattern.Flag::getValue).reduce((f1, f2) -> f1 | f2).orElse(0));
        this.regexp = regex;
    }

    @Override
    public void validate(String actual, HttpModelType httpModelType, String modelName) {
        if (actual != null && !this.pattern.matcher(actual).matches()) {
            throw new ValidationException("Invalid ? \"?\": Expected that 'value' matches the pattern: /?/, where 'value' is '?'!", new Object[]{httpModelType, modelName, this.regexp, actual});
        }
    }
}

