/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.validator;

import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.ConstraintValidator;
import io.rxmicro.validation.base.AbstractDateTimeEqualsConstraintValidator;
import java.time.Instant;

public class PastOrPresentInstantConstraintValidator
extends AbstractDateTimeEqualsConstraintValidator
implements ConstraintValidator<Instant> {
    @Override
    public void validate(Instant actual, HttpModelType httpModelType, String modelName) {
        Instant expected;
        if (actual != null && this.isNotEqualsAfterTruncation((expected = Instant.now()).toEpochMilli(), actual.toEpochMilli()) && actual.compareTo(expected) > 0) {
            throw new ValidationException("Invalid ? \"?\": Expected a past or present instant, but actual is '?' (now is '?')!", new Object[]{httpModelType, modelName, actual, expected});
        }
    }
}

