/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.validator;

import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.ConstraintValidator;
import java.math.BigDecimal;

public class NumericConstraintValidator
implements ConstraintValidator<BigDecimal> {
    private final int expectedPrecision;
    private final int expectedScale;

    public NumericConstraintValidator(int expectedPrecision, int expectedScale) {
        this.expectedPrecision = expectedPrecision;
        this.expectedScale = expectedScale;
    }

    @Override
    public void validate(BigDecimal actual, HttpModelType httpModelType, String modelName) {
        if (actual != null) {
            if (this.expectedScale != -1 && this.expectedScale != actual.scale()) {
                throw new ValidationException("Invalid ? \"?\": Expected scale = ?, but actual is ?!", new Object[]{httpModelType, modelName, this.expectedScale, actual.scale()});
            }
            if (this.expectedPrecision != -1 && this.expectedPrecision != actual.precision()) {
                throw new ValidationException("Invalid ? \"?\": Expected precision = ?, but actual is ?!", new Object[]{httpModelType, modelName, this.expectedPrecision, actual.precision()});
            }
        }
    }
}

