/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.validator;

import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.ConstraintValidator;
import java.util.Set;
import java.util.stream.Collectors;

public final class LatinAlphabetOnlyConstraintValidator
implements ConstraintValidator<String> {
    private final Set<Character> alphabet;

    public LatinAlphabetOnlyConstraintValidator(boolean allowsUppercase, boolean allowsLowercase, boolean allowsDigits, String punctuations) {
        this.alphabet = LatinAlphabetHelper.buildLatinAlphabet(allowsUppercase, allowsLowercase, allowsDigits, punctuations);
    }

    @Override
    public void validate(String actual, HttpModelType httpModelType, String modelName) {
        if (actual != null) {
            for (int i = 0; i < actual.length(); ++i) {
                char ch = actual.charAt(i);
                if (this.alphabet.contains(Character.valueOf(ch))) continue;
                throw new ValidationException("Invalid ? \"?\": Expected a string which contains the following characters only [[?]], but actual value contains invalid character: '?' (0x?)!", new Object[]{httpModelType, modelName, this.alphabetToString(), Character.valueOf(ch), Integer.toHexString(ch)});
            }
        }
    }

    private String alphabetToString() {
        StringBuilder sb = new StringBuilder();
        for (Character character : this.alphabet) {
            if (character.charValue() == '\n') {
                sb.append("\\n");
                continue;
            }
            if (character.charValue() == '\t') {
                sb.append("\\t");
                continue;
            }
            if (character.charValue() == '\r') {
                sb.append("\\r");
                continue;
            }
            if (character.charValue() == '\b') {
                sb.append("\\b");
                continue;
            }
            sb.append(character);
        }
        return sb.toString();
    }

    private static final class LatinAlphabetHelper {
        private LatinAlphabetHelper() {
        }

        private static Set<Character> buildLatinAlphabet(boolean allowsUppercase, boolean allowsLowercase, boolean allowsDigits, String punctuations) {
            StringBuilder builder = new StringBuilder(69);
            if (allowsUppercase) {
                builder.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
            }
            if (allowsLowercase) {
                builder.append("abcdefghijklmnopqrstuvwxyz");
            }
            if (allowsDigits) {
                builder.append("1234567890");
            }
            for (int i = 0; i < punctuations.length(); ++i) {
                char ch2 = punctuations.charAt(i);
                if (builder.indexOf(String.valueOf(ch2)) != -1) continue;
                builder.append(ch2);
            }
            return builder.toString().chars().mapToObj(ch -> Character.valueOf((char)ch)).collect(Collectors.toSet());
        }
    }
}

