/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.validator;

import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.ConstraintValidator;
import io.rxmicro.validation.constraint.IP;
import java.util.Collection;
import java.util.Set;
import java.util.StringTokenizer;

public class IPConstraintValidator
implements ConstraintValidator<String> {
    private static final int EXPECTED_IP_4_TOKENS_COUNT = 4;
    private static final int MIN_IP_VALUE = 0;
    private static final int MAX_IP_4_VALUE = 255;
    private static final int MAX_IP_6_VALUE = 65535;
    private static final String MAX_IP_6_VALUE_TO_STRING = Integer.toHexString(65535);
    private static final String INVALID_IP_ERROR_MESSAGE_TEMPLATE = "Invalid ? \"?\": Expected a number between ? and ?, but actual is '?' (IP = '?')!";
    private final Set<IP.Version> versions;

    public IPConstraintValidator(Collection<IP.Version> versions) {
        this.versions = Set.copyOf(versions);
    }

    @Override
    public void validate(String actual, HttpModelType httpModelType, String modelName) {
        if (actual != null && actual.length() > 0) {
            if (this.versions.size() == 1) {
                if (this.versions.contains((Object)IP.Version.IP_V4)) {
                    this.validateIPv4(actual, httpModelType, modelName);
                } else {
                    this.validateIPv6(actual, httpModelType, modelName);
                }
            } else if (actual.contains(".")) {
                this.validateIPv4(actual, httpModelType, modelName);
            } else if (actual.contains(":")) {
                this.validateIPv6(actual, httpModelType, modelName);
            } else {
                throw new ValidationException("Invalid ? \"?\": Expected IPv4 or IPv6, but actual is '?'!", new Object[]{httpModelType, modelName, actual});
            }
        }
    }

    private void validateIPv4(String actual, HttpModelType httpModelType, String fieldName) {
        StringTokenizer tokenizer = new StringTokenizer(actual, ".");
        if (tokenizer.countTokens() != 4) {
            throw new ValidationException("Invalid ? \"?\": Expected ? numbers divided by '.', but actual is '?'!", new Object[]{httpModelType, fieldName, 4, actual});
        }
        while (tokenizer.hasMoreTokens()) {
            String value = tokenizer.nextToken();
            try {
                int ip4AddressPart = Integer.parseInt(value);
                if (ip4AddressPart >= 0 && ip4AddressPart <= 255) continue;
                throw new ValidationException(INVALID_IP_ERROR_MESSAGE_TEMPLATE, new Object[]{httpModelType, fieldName, 0, 255, ip4AddressPart, actual});
            }
            catch (NumberFormatException ignore) {
                throw new ValidationException(INVALID_IP_ERROR_MESSAGE_TEMPLATE, new Object[]{httpModelType, fieldName, 0, 255, value, actual});
            }
        }
    }

    private void validateIPv6(String actual, HttpModelType httpModelType, String fieldName) {
        StringTokenizer tokenizer = new StringTokenizer(actual, ":");
        while (tokenizer.hasMoreTokens()) {
            String value = tokenizer.nextToken();
            if (value.isEmpty()) continue;
            try {
                int ip6AddressPart = Integer.decode("0x" + value);
                if (ip6AddressPart >= 0 && ip6AddressPart <= 65535) continue;
                throw new ValidationException(INVALID_IP_ERROR_MESSAGE_TEMPLATE, new Object[]{httpModelType, fieldName, 0, MAX_IP_6_VALUE_TO_STRING, Integer.toHexString(ip6AddressPart), actual});
            }
            catch (NumberFormatException ignore) {
                throw new ValidationException(INVALID_IP_ERROR_MESSAGE_TEMPLATE, new Object[]{httpModelType, fieldName, 0, MAX_IP_6_VALUE_TO_STRING, value, actual});
            }
        }
    }
}

