/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.validator;

import io.rxmicro.common.util.ExCollections;
import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.ConstraintValidator;
import java.util.Collection;
import java.util.Set;

public class EnumerationStringConstraintValidator
implements ConstraintValidator<String> {
    private final Set<String> allowed;

    public EnumerationStringConstraintValidator(Collection<String> allowed) {
        this.allowed = ExCollections.unmodifiableOrderedSet(allowed);
    }

    @Override
    public void validate(String actual, HttpModelType httpModelType, String modelName) {
        if (actual != null && !this.allowed.contains(actual)) {
            throw new ValidationException("Invalid ? \"?\": Expected a value from the set ?, but actual is '?'!", new Object[]{httpModelType, modelName, this.allowed, actual});
        }
    }
}

