/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.validator;

import io.rxmicro.common.util.ExCollectors;
import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.ConstraintValidator;
import java.util.Collection;
import java.util.Set;

public class EnumerationCharacterConstraintValidator
implements ConstraintValidator<Character> {
    private final Set<Character> allowed;

    public EnumerationCharacterConstraintValidator(Collection<String> allowed) {
        this.allowed = (Set)allowed.stream().map(s -> Character.valueOf(s.charAt(0))).collect(ExCollectors.toOrderedSet());
    }

    @Override
    public void validate(Character actual, HttpModelType httpModelType, String modelName) {
        if (actual != null && !this.allowed.contains(actual)) {
            throw new ValidationException("Invalid ? \"?\": Expected a value from the set ?, but actual is '?' (0x?)!", new Object[]{httpModelType, modelName, this.allowed, actual, Integer.toHexString(actual.charValue())});
        }
    }
}

