/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.validator;

import io.rxmicro.common.util.Formats;
import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.ConstraintValidator;
import io.rxmicro.validation.base.ConstraintUtils;
import io.rxmicro.validation.validator.DomainNameConstraintValidator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class EmailConstraintValidator
implements ConstraintValidator<String> {
    public static final String EMAIL_PREFIX_RULE = "Prefix must contains letters [a-z] or [A-Z], digits [0-9], underscores, periods, dashes, apostrophe and plus only!";
    public static final String EMAIL_DOMAIN_RULE = "Domain name must contains letters [a-z] or [A-Z], digits [0-9], underscores, periods, and dashes only!";
    private static final Set<Character> ALLOWED_PREFIX_CHARACTERS = Stream.concat(ConstraintUtils.getLatinLettersAndDigits().stream(), Stream.of(Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('\''), Character.valueOf('+'))).collect(Collectors.toUnmodifiableSet());
    private final boolean errorWithDetails;
    private final DomainNameConstraintValidator domainNameConstraintValidator;

    public EmailConstraintValidator(boolean errorWithDetails) {
        this.errorWithDetails = errorWithDetails;
        this.domainNameConstraintValidator = new DomainNameConstraintValidator(errorWithDetails);
    }

    @Override
    public void validate(String actual, HttpModelType httpModelType, String modelName) {
        int lastIndex;
        if (actual != null && (lastIndex = actual.length() - 1) >= 0) {
            this.validateActual(actual, httpModelType, modelName, lastIndex);
        }
    }

    private void validateActual(String actual, HttpModelType httpModelType, String modelName, int lastIndex) {
        boolean atSignDelimiterFound = false;
        for (int i = 0; i <= lastIndex; ++i) {
            char ch = actual.charAt(i);
            if (ch == '@') {
                this.validatePrefixAndDomain(actual, httpModelType, modelName, lastIndex, i);
                atSignDelimiterFound = true;
                break;
            }
            if (!ALLOWED_PREFIX_CHARACTERS.contains(Character.valueOf(ch))) {
                String details = Formats.format((String)"Unsupported prefix character: '?'. ?", (Object[])new Object[]{Character.valueOf(ch), EMAIL_PREFIX_RULE});
                this.throwException(httpModelType, modelName, details);
                continue;
            }
            if (ch != '.' && ch != '-' && ch != '_' && ch != '\'' && ch != '+') continue;
            this.validateDelimiters(actual, httpModelType, modelName, i, ch);
        }
        if (!atSignDelimiterFound) {
            this.throwException(httpModelType, modelName, "Missing '@'!");
        }
    }

    private void validatePrefixAndDomain(String actual, HttpModelType httpModelType, String modelName, int lastIndex, int index) {
        if (index == 0) {
            this.throwException(httpModelType, modelName, "Missing prefix!");
        } else if (index == lastIndex) {
            this.throwException(httpModelType, modelName, "Missing domain!");
        } else {
            char prev = actual.charAt(index - 1);
            if (prev == '.' || prev == '_' || prev == '-' || prev == '\'' || prev == '+') {
                this.throwException(httpModelType, modelName, Formats.format((String)"Prefix can't end with '?'!", (Object[])new Object[]{Character.valueOf(prev)}));
            } else {
                this.domainNameConstraintValidator.validate(actual.substring(index + 1), httpModelType, modelName);
            }
        }
    }

    private void validateDelimiters(String actual, HttpModelType httpModelType, String modelName, int index, char ch) {
        if (index == 0) {
            this.throwException(httpModelType, modelName, Formats.format((String)"Prefix can't start with '?'!", (Object[])new Object[]{Character.valueOf(ch)}));
        } else {
            char prev = actual.charAt(index - 1);
            if (prev == '.' || prev == '-' || prev == '_' || prev == '\'' || prev == '+') {
                this.throwException(httpModelType, modelName, Formats.format((String)"Prefix contains redundant character: '?'!", (Object[])new Object[]{Character.valueOf(ch)}));
            }
        }
    }

    private void throwException(HttpModelType httpModelType, String modelName, String details) {
        String errorMessage = this.errorWithDetails ? Formats.format((String)"Invalid ? \"?\": ?", (Object[])new Object[]{httpModelType, modelName, details}) : Formats.format((String)"Invalid ? \"?\": Expected a valid email format!", (Object[])new Object[]{httpModelType, modelName});
        throw new ValidationException(errorMessage);
    }
}

