/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.validator;

import io.rxmicro.common.ImpossibleException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.ConstraintValidator;
import io.rxmicro.validation.base.AbstractCompositionConstraintValidator;
import io.rxmicro.validation.constraint.CountryCode;
import io.rxmicro.validation.detail.StatelessValidators;
import io.rxmicro.validation.validator.DigitsOnlyConstraintValidator;
import io.rxmicro.validation.validator.LengthConstraintValidator;
import io.rxmicro.validation.validator.UppercaseConstraintValidator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class CountryCodeConstraintValidator
implements ConstraintValidator<String> {
    private static final Map<CountryCode.Format, ConstraintValidator<String>> CLASS_MAP = Map.of(CountryCode.Format.ISO_3166_1_ALPHA_2, new Alpha2ConstraintValidator(), CountryCode.Format.ISO_3166_1_ALPHA_3, new Alpha3ConstraintValidator(), CountryCode.Format.ISO_3166_1_NUMERIC, new NumericConstraintValidator());
    private final ConstraintValidator<String> constraintValidator;

    public CountryCodeConstraintValidator(CountryCode.Format format) {
        this.constraintValidator = Optional.ofNullable(CLASS_MAP.get((Object)format)).orElseThrow(() -> {
            throw new ImpossibleException("Unsupported format: ?", new Object[]{format});
        });
    }

    @Override
    public void validate(String actual, HttpModelType httpModelType, String modelName) {
        this.constraintValidator.validate(actual, httpModelType, modelName);
    }

    private static final class NumericConstraintValidator
    extends AbstractCompositionConstraintValidator<String> {
        private NumericConstraintValidator() {
            super(List.of(new LengthConstraintValidator(3), StatelessValidators.getStatelessValidator(DigitsOnlyConstraintValidator.class)));
        }
    }

    private static final class Alpha3ConstraintValidator
    extends AbstractCompositionConstraintValidator<String> {
        private Alpha3ConstraintValidator() {
            super(List.of(new LengthConstraintValidator(3), StatelessValidators.getStatelessValidator(UppercaseConstraintValidator.class)));
        }
    }

    private static final class Alpha2ConstraintValidator
    extends AbstractCompositionConstraintValidator<String> {
        private Alpha2ConstraintValidator() {
            super(List.of(new LengthConstraintValidator(2), StatelessValidators.getStatelessValidator(UppercaseConstraintValidator.class)));
        }
    }
}

