/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.validator;

import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.ConstraintValidator;
import io.rxmicro.validation.base.ConstraintUtils;
import io.rxmicro.validation.constraint.Base64URLEncoded;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Base64URLEncodedConstraintValidator
implements ConstraintValidator<String> {
    private static final Set<Character> ALPHABET_BASE = Stream.concat(ConstraintUtils.getLatinLettersAndDigits().stream(), Stream.of(Character.valueOf('+'), Character.valueOf('/'))).collect(Collectors.toUnmodifiableSet());
    private static final Set<Character> ALPHABET_URL = Stream.concat(ConstraintUtils.getLatinLettersAndDigits().stream(), Stream.of(Character.valueOf('-'), Character.valueOf('_'))).collect(Collectors.toUnmodifiableSet());
    private final Base64URLEncoded.Alphabet alphabet;

    public Base64URLEncodedConstraintValidator(Base64URLEncoded.Alphabet alphabet) {
        this.alphabet = alphabet;
    }

    @Override
    public void validate(String actual, HttpModelType httpModelType, String modelName) {
        if (actual != null) {
            if (this.alphabet == Base64URLEncoded.Alphabet.BASE) {
                this.validate(actual, httpModelType, modelName, ALPHABET_BASE);
            } else {
                this.validate(actual, httpModelType, modelName, ALPHABET_URL);
            }
        }
    }

    private void validate(CharSequence value, HttpModelType httpModelType, String modelName, Set<Character> alphabet) {
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (alphabet.contains(Character.valueOf(ch))) continue;
            throw new ValidationException("Invalid ? \"?\": Expected a valid Base64 string, i.e. string which contains the following characters only [?], but actual value contains invalid character: '?' (0x?)!", new Object[]{httpModelType, modelName, new TreeSet<Character>(alphabet), Character.valueOf(ch), Integer.toHexString(ch)});
        }
    }
}

