/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.validator;

import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Strings;
import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;
import io.rxmicro.validation.ConstraintValidator;
import io.rxmicro.validation.base.ConstraintUtils;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractDomainOrHostNameConstraintValidator
implements ConstraintValidator<String> {
    private static final Set<Character> ALLOWED_CHARACTERS = Stream.concat(ConstraintUtils.getLatinLettersAndDigits().stream(), Stream.of(Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'))).collect(Collectors.toUnmodifiableSet());
    private final boolean errorWithDetails;

    protected AbstractDomainOrHostNameConstraintValidator(boolean errorWithDetails) {
        this.errorWithDetails = errorWithDetails;
    }

    protected abstract String getRule();

    protected abstract String getName();

    @Override
    public final void validate(String actual, HttpModelType httpModelType, String modelName) {
        int lastIndex;
        if (actual != null && (lastIndex = actual.length() - 1) >= 0) {
            this.validateActual(actual, httpModelType, modelName, lastIndex);
        }
    }

    private void validateActual(String actual, HttpModelType httpModelType, String modelName, int lastIndex) {
        int lastPeriodIndex = -1;
        for (int i = 0; i <= lastIndex; ++i) {
            char ch = actual.charAt(i);
            if (!ALLOWED_CHARACTERS.contains(Character.valueOf(ch))) {
                String details = Formats.format((String)"Unsupported ? character: '?'. ?", (Object[])new Object[]{this.getName(), Character.valueOf(ch), this.getRule()});
                this.throwException(httpModelType, modelName, details);
                continue;
            }
            if (ch == '.') {
                lastPeriodIndex = i;
                this.validateDelimiterCharacters(actual, httpModelType, modelName, lastIndex, i, ch);
                continue;
            }
            if (ch != '-' && ch != '_') continue;
            this.validateDelimiterCharacters(actual, httpModelType, modelName, lastIndex, i, ch);
        }
        if (lastPeriodIndex == -1) {
            String message = Formats.format((String)"? must contain at least two levels!", (Object[])new Object[]{this.getName()});
            this.throwException(httpModelType, modelName, message);
        } else if (lastIndex - lastPeriodIndex < 2) {
            String message = Formats.format((String)"The last portion of the ? must be at least two characters!", (Object[])new Object[]{this.getName()});
            this.throwException(httpModelType, modelName, message);
        }
    }

    private void validateDelimiterCharacters(String actual, HttpModelType httpModelType, String modelName, int lastIndex, int index, char ch) {
        if (index == 0) {
            this.throwException(httpModelType, modelName, Formats.format((String)"? can't start with '?'!", (Object[])new Object[]{this.getName(), Character.valueOf(ch)}));
        } else if (index == lastIndex) {
            this.throwException(httpModelType, modelName, Formats.format((String)"? can't end with '?'!", (Object[])new Object[]{this.getName(), Character.valueOf(ch)}));
        } else {
            char prev = actual.charAt(index - 1);
            if (prev == '.' || prev == '_' || prev == '-') {
                this.throwException(httpModelType, modelName, Formats.format((String)"? contains redundant character: '?'!", (Object[])new Object[]{this.getName(), Character.valueOf(ch)}));
            }
        }
    }

    private void throwException(HttpModelType httpModelType, String modelName, String details) {
        String errorMessage = this.errorWithDetails ? Formats.format((String)"Invalid ? \"?\": ?", (Object[])new Object[]{httpModelType, modelName, Strings.capitalize((String)details)}) : Formats.format((String)"Invalid ? \"?\": Expected a valid ?!", (Object[])new Object[]{httpModelType, modelName, this.getName()});
        throw new ValidationException(errorMessage);
    }
}

