/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.internal;

import io.rxmicro.http.error.ValidationException;
import io.rxmicro.rest.model.HttpModelType;

public final class ConstraintValidators {
    public static <T extends Comparable<T>> void validateMaxValue(T maxValue, boolean inclusive, T actual, HttpModelType httpModelType, String modelName, String inclusiveErrorMessageTemplate, String exclusiveErrorMessageTemplate) {
        if (actual != null) {
            if (inclusive) {
                if (actual.compareTo(maxValue) > 0) {
                    throw new ValidationException(inclusiveErrorMessageTemplate, new Object[]{httpModelType, modelName, maxValue, actual});
                }
            } else if (actual.compareTo(maxValue) >= 0) {
                throw new ValidationException(exclusiveErrorMessageTemplate, new Object[]{httpModelType, modelName, maxValue, actual});
            }
        }
    }

    public static <T extends Comparable<T>> void validateMinValue(T minValue, boolean inclusive, T actual, HttpModelType httpModelType, String modelName, String inclusiveErrorMessageTemplate, String exclusiveErrorMessageTemplate) {
        if (actual != null) {
            if (inclusive) {
                if (actual.compareTo(minValue) < 0) {
                    throw new ValidationException(inclusiveErrorMessageTemplate, new Object[]{httpModelType, modelName, minValue, actual});
                }
            } else if (actual.compareTo(minValue) <= 0) {
                throw new ValidationException(exclusiveErrorMessageTemplate, new Object[]{httpModelType, modelName, minValue, actual});
            }
        }
    }

    private ConstraintValidators() {
    }
}

