/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.validation.detail;

import io.rxmicro.http.error.ValidationException;
import io.rxmicro.validation.ConstraintValidator;
import io.rxmicro.validation.UnexpectedResponseException;
import java.util.List;

public final class ResponseValidators {
    public static <T> void validateResponse(boolean shouldValidationBeActivated, ConstraintValidator<T> validator, T response) {
        if (shouldValidationBeActivated) {
            ResponseValidators.validateResponse(validator, response);
        }
    }

    public static <T> void validateResponse(ConstraintValidator<T> validator, T response) {
        try {
            validator.validate(response);
        }
        catch (ValidationException ex) {
            throw new UnexpectedResponseException("Response is invalid: ?", ex.getMessage());
        }
    }

    public static <T> void validateResponse(boolean shouldValidationBeActivated, ConstraintValidator<T> validator, List<T> response) {
        if (shouldValidationBeActivated) {
            ResponseValidators.validateResponse(validator, response);
        }
    }

    public static <T> void validateResponse(ConstraintValidator<T> validator, List<T> response) {
        try {
            validator.validateIterable(response);
        }
        catch (ValidationException ex) {
            throw new UnexpectedResponseException("Response is invalid: ?", ex.getMessage());
        }
    }

    public static <T> void validateIfResponseExists(ConstraintValidator<T> validator, T response) {
        if (response != null) {
            ResponseValidators.validateResponse(validator, response);
        }
    }

    public static <T> void validateIfResponseExists(ConstraintValidator<T> validator, List<T> response) {
        if (response != null) {
            ResponseValidators.validateResponse(validator, response);
        }
    }

    private ResponseValidators() {
    }
}

